/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#ifndef KMOBILETOOLSHELPER_H
#define KMOBILETOOLSHELPER_H

#include <qobject.h>
#include "contactptrlist.h"
#include <qdir.h>
#include <ksystemtray.h>

/**
    @author Marco Gulino <marco@kmobiletools.org>
*/
namespace KMobileTools
{
    class KMobiletoolsHelper : public QObject
    {
    Q_OBJECT
    public:
        KMobiletoolsHelper(QObject *parent = 0, const char *name = 0);
        enum Connection {
            USB=0x1,
            Serial=0x2,
            IRDA=0x4,
            Bluetooth=0x8
        };
        enum SlotSource {
            PhoneBook=0x1,
            SMS=0x2
        };

        ~KMobiletoolsHelper();
        static KMobiletoolsHelper *instance(){ if(p_instance) return p_instance; else return new KMobiletoolsHelper(); }
        static const QStringList getStdDevices(int connectionFlags);
        static const QStringList getStdDevices(int connectionFlags, QStringList oldDevices);
        /**
         * Checks if number1 and number2 are equals.
         * */
        static bool compareNumbers(const QString number1, const QString number2);
            /** Checks if the number is stored in the addressbook and returns the
        * owner if found.
            */
        static const QString translateNumber( const QString &s_number );
        static const QString translateNumber( const QString &s_number, ContactPtrList *phoneBook );
        /** This method removes the international call prefix and normalizes.
        * This is used to compare two numbers with different prefix
        * shemes
        */
        static const QString removeIntPrefix( const QString &number );
        /** This method can give us a standard template for all KMobileTools item details, i.e. SMS, PhoneBook, and.. we'll see ;-)
         * */
        static const QString getTemplate();
        /** This method parses arguments so that it can give us a HTML link
         * */
        static const QString getFooterLink(const QString &text, const QString &iconName, const QString &url);
        static void createMailDir(const QString &dirname);
        static QString mkMailDir(const QString &dirname, bool isParent=false);
        static QString shortMonthNameEng(int month);
        static QString shortWeekDayNameEng(int day);
        KSystemTray *systray() { return p_sysTray; }
        void setSystray(KSystemTray *s) { p_sysTray=s; }
        static QString memorySlotsDescriptions(const QString &slot, int type);
    private:
        static KMobiletoolsHelper *p_instance;
        KSystemTray *p_sysTray;
    };
}
#endif
