/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#ifndef PICKPHONENUMBERDIALOG_H
#define PICKPHONENUMBERDIALOG_H

#include <kdialogbase.h>
#include "ui_pickphonenumber.h"
#include "contactptrlist.h"
#include <kabc/addressee.h>
#include <klistviewsearchline.h>
#include <kdeversion.h>


/**
	@author Marco Gulino <marco@kmobiletools.org>
*/

class NameSearchLine : public KListViewSearchLine
{
    public:
        NameSearchLine(QWidget *parent=0, KListView *listView=0, const char *name=0)
    : KListViewSearchLine(parent,listView, name) {}
    protected:
        bool itemMatches(const QListViewItem *item, const QString &s) const;
};

#if KDE_IS_VERSION( 3, 4, 0 )
class NameSearchLineWidget : public KListViewSearchLineWidget
{
    public:
        NameSearchLineWidget(KListView *listView = 0, QWidget *parent = 0,const char *name = 0)
    : KListViewSearchLineWidget(listView, parent, name) {}

        KListViewSearchLine *createSearchLine(KListView *listView)
    {
        return new NameSearchLine(this, listView);
    }
};
#endif

class PickPhoneNumberDialog : public KDialogBase
{
Q_OBJECT
public:
    PickPhoneNumberDialog(QWidget *parent = 0, const char *name = 0);

    ~PickPhoneNumberDialog();
    const QStringList selectedNumbers() { return s_selectedNumbers; }
    private:
        ui_PickPhoneNumber *m_widget;
        KMobileTools::ContactPtrList *addresseeList;
        QStringList s_selectedNumbers;

public slots:
    void slotSourceChanged(int);
    void updateNumbersList();
    void updatePhonebook();
    void click( QListViewItem *, const QPoint &, int );
    void doubleClick( QListViewItem *, const QPoint &, int );
};

#endif
