/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include "popupaddressee.h"
#include "popupnumber.h"
#include <kabc/addressee.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kdebug.h>
#include <klocale.h>

#define EDIT_ID 1
#define DELETE_ID 2

popupAddressee::popupAddressee(KABC::Addressee *addressee, QWidget *parent, const char *name, bool ro)
 : KPopupMenu(parent, name)
{
    if(!addressee) return;
    this->addressee=addressee;
    insertTitle( KGlobal::iconLoader()->loadIcon( "personal", KIcon::Small, KIcon::SizeSmall ), addressee->formattedName() );
    if(!ro) {
        insertItem( KGlobal::iconLoader()->loadIconSet("edit", KIcon::Small, KIcon::SizeSmall),
                    i18n("Edit"), EDIT_ID);
        insertItem(  KGlobal::iconLoader()->loadIconSet("editdelete", KIcon::Small, KIcon::SizeSmall),
                    i18n("Delete"), DELETE_ID);
    }
    QValueListIterator<KABC::PhoneNumber> it;
    QValueList<KABC::PhoneNumber> p_list=addressee->phoneNumbers();
    for( it=p_list.begin(); it!=p_list.end() ;++it )
        insertItem( (*it).number(), new popupNumber( (*it).number(), this, name ) );
    connect(this, SIGNAL(activated(int) ), this, SLOT(activated(int ) ) );
}


popupAddressee::~popupAddressee()
{
}


#include "popupaddressee.moc"


/*!
    \fn popupAddressee::activated(int id)
 */
void popupAddressee::activated(int id)
{
    switch( id ){
        case EDIT_ID:
            emit editClicked( addressee );
            break;
        case DELETE_ID:
            emit delContact();
            break;
    }
}
