/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include "popupnumber.h"

#include <klocale.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kdebug.h>

#include "engineslist.h"
#include "deviceIFace_stub.h"
#include "kmobiletools_devices.h"

#define CALL_ID 1
#define CALL_O_ID 2
#define SMS_ID 3
#define SMS_O_ID 4

popupNumber::popupNumber(QString number, QWidget *parent, const char *name)
 : KPopupMenu(parent, name)
{
    kdDebug() << "popupNumber with name " << name << endl;
    insertTitle(number);
    this->number=number;
    insertItem(KGlobal::iconLoader()->loadIconSet("kaddressbook", KIcon::Small, KIcon::SizeSmall), i18n("Call with this mobile phone"), CALL_ID, CALL_ID );
    insertItem(KGlobal::iconLoader()->loadIconSet("mail_generic", KIcon::Small, KIcon::SizeSmall), i18n("Send a SMS with this mobile phone"), SMS_ID, SMS_ID);
    if(EnginesList::instance()->count() >1 )
    {
        devicesPopup *callsPopup=new devicesPopup(0, name);
        devicesPopup *smsPopup=new devicesPopup(0, name);

        insertItem(KGlobal::iconLoader()->loadIconSet("kaddressbook", KIcon::Small, KIcon::SizeSmall), i18n("Call with..."), callsPopup, CALL_O_ID, CALL_O_ID );
        insertItem(KGlobal::iconLoader()->loadIconSet("mail_generic", KIcon::Small, KIcon::SizeSmall), i18n("Send a SMS with..."), smsPopup, SMS_O_ID, SMS_O_ID );
        connect(callsPopup, SIGNAL(deviceActivated( const QString& ) ), this, SLOT(call( const QString& ) ) );
        connect(smsPopup, SIGNAL(deviceActivated( const QString& ) ), this, SLOT(newSMS( const QString& ) ) );
    }
    connect(this, SIGNAL(activated ( int ) ), this, SLOT(activated( int ) ) );
}


popupNumber::~popupNumber()
{
}

void popupNumber::call(const QString &deviceName)
{
    kdDebug() << "call: " << deviceName << endl;
    DeviceIFace_stub *stub=new DeviceIFace_stub("kmobiletools", deviceName.latin1() );
    stub->raiseDevice();
    stub->raisePage(2);
    stub->slotDialNumber(number);
}

void popupNumber::newSMS(const QString &deviceName)
{
    kdDebug() << "sms: " << deviceName << endl;
    (new DeviceIFace_stub("kmobiletools", deviceName.latin1() ))->slotNewSMS(number);
}

void popupNumber::activated(int id)
{
    kdDebug() << "popupNumber::activated(" << id << ")\n";
    switch( id ){
        case CALL_ID:
            call( name() ); break;
        case SMS_ID:
            newSMS( name() ); break;
    }
}




devicesPopup::devicesPopup( QWidget *parent, const char *name)
    : KPopupMenu( parent, name )
{
    sl_devices=EnginesList::instance()->namesList( false );
    QStringList::Iterator it;
    int i=0;
    for(it=sl_devices.begin(); it!=sl_devices.end(); ++it)
    {
        if(!DeviceConfigInstance(*it)->devicename().length()) continue;
        //if( ! (*it).contains(name) )
        insertItem(KGlobal::iconLoader()->loadIconSet("kmobiletools", KIcon::Small, KIcon::SizeSmall), DeviceConfigInstance(*it)->devicename(), i, i);
        i++;
    }
    connect(this, SIGNAL(activated ( int ) ), this, SLOT(activated( int ) ) );
}

devicesPopup::~devicesPopup()
{
}


void devicesPopup::activated(int id)
{
    kdDebug() << "devicesPopup::activated(" << id << ")\n";
    emit deviceActivated( *(sl_devices.at( id )) );
}

#include "popupnumber.moc"
