/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include <kcombobox.h>


class StringComboBox : public KComboBox
{
    Q_OBJECT
    Q_PROPERTY( QString currentText READ currentText WRITE setCurrentText DESIGNABLE true SCRIPTABLE true )
    Q_PROPERTY( int currentItem READ currentItem WRITE setCurrentItem DESIGNABLE false SCRIPTABLE false )

    public:
        StringComboBox(bool rw, QWidget* parent, const char* name)
    : KComboBox(rw,parent,name) {}
        StringComboBox(QWidget* parent, const char* name)
    :KComboBox(parent,name) {}
        QString currentText() const { return KComboBox::currentText(); }
        void setCurrentText(const QString &text) { KComboBox::setCurrentText(text);}
        int currentItem() const { return KComboBox::currentItem(); }
        void setCurrentItem(int i) { KComboBox::setCurrentItem(i); }
};
