/*
*
*  KDE Blutooth BlueMonitor 
*
*  Copyright (C) 2007  Tom Patzig <tpatzig@suse.de>
*
*
*  This file is part of kbluemon.
*
*  kbluemon is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  kbluemon is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with kbluemon; if not, write to the Free Software
*  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*/
#include "bluemonitor.h"

#ifdef KBLUETOOTH_NEW

#include <kdialogbase.h>
#include <qlistview.h>
#include <qdom.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <string>
#include <dbus/dbus.h>



BlueMonitor::BlueMonitor(QListView *listview) : QObject()
{
    p_listview=listview;
    KBluetooth::DBusInit *dbus = new KBluetooth::DBusInit();
    conn = dbus->getDBus();
    manager = new KBluetooth::Manager(conn);
    adapter = new KBluetooth::Adapter(manager->defaultAdapter(), conn);

    if (!adapter->isPeriodicDiscovery()) {
        adapter->startPeriodicDiscovery();
        selfstart = 1;
    } else {

        connect(adapter, SIGNAL(periodicDiscoveryStopped()), this, SLOT(restartPeriodicDiscovery()));
    }

    if (!adapter->getPeriodicDiscoveryNameResolving())
        adapter->setPeriodicDiscoveryNameResolving(1);


        connect(adapter, SIGNAL(remoteDeviceFound(const QString&, int, short)), this, SLOT(newdev(const QString&, int, short)));
        connect(adapter, SIGNAL(remoteNameUpdated(const QString&, const QString&)), this, SLOT(chg_name(const QString&, const QString&)));
        connect(adapter, SIGNAL(remoteDeviceDisappeared(const QString&)), this, SLOT(deldev(const QString&)));


    connect(p_listview, SIGNAL(clicked(QListViewItem*)), this, SLOT(chg_details(QListViewItem*)));

    rx.setPattern("^\\d+");
    rx.setMinimal(TRUE);

    p_listview->hideColumn(3);	
}

BlueMonitor::~BlueMonitor() {

    kdDebug() << k_funcinfo << endl;
    if (adapter->isPeriodicDiscovery() && selfstart)
        adapter->stopPeriodicDiscovery();
}




void BlueMonitor::newdev(const QString& name, int dev_class, short rssi) {

    kdDebug() << k_funcinfo << endl;
    kdDebug() << "name=" << name << ", dev_class=" << dev_class << ", rssi=" << rssi << endl;
    BtDeviceItem *item;
    QListViewItemIterator it( p_listview );
    while ( it.current() ) {
        item = (BtDeviceItem*)(it.current());
        if(item->address() == name) return;
        ++it;
    }
    item=new BtDeviceItem((KListView*)p_listview, name, QString());
    RemoteDevice* newDev = getDetails(name,rssi);
    item->setDevice(newDev);
    getServices(newDev);
    deviceList.push_back(newDev);
    /*
    QString msg;
    QString signal = QString::number(rssi) + "%";
    QString devcl = QString::number(dev_class);
    for(it = deviceList.begin(); it!= deviceList.end(); ++it) {
        if ((**it).addr == name) {
            (**it).rssi = rssi;
            QListViewItem *tmp = p_listview->findItem((**it).name,0,Qt::ExactMatch);
            tmp->setText(1,signal);
            if ((**it).version == "<i>not available</i>") {

                (**it).version = adapter->getRemoteVersion(name);
                (**it).revision = adapter->getRemoteRevision(name);
                (**it).major_class = adapter->getRemoteMajorClass(name);
                (**it).manufacturer = adapter->getRemoteManufacturer(name);

            }
            if (dev_addr->text() == (**it).addr) {
                strength->setProgress(rssi);
                if ((**it).version == "<i>not available</i>")
                    chg_details(tmp);	
            }

            return;
        }
    }


    if (deviceList.empty()) {
        strength->setProgress(rssi);
        dev_addr->setText(name);
        dev_version->setText(newDev->version);
        dev_revision->setText(newDev->revision);
        dev_manufacturer->setText(newDev->manufacturer);
        dev_category->setText(QString(newDev->dev_class + ", " + newDev->major_class));
        dev_Info->setText(newDev->devInfo);
        for (newDev->serv_it = newDev->pservices.begin(); newDev->serv_it!=newDev->pservices.end(); ++newDev->serv_it) {
            kdDebug() << k_funcinfo << *newDev->serv_it << endl;
            service_list->insertItem(*newDev->serv_it);
        }

    }
*/


//     QListViewItem *bla = new QListViewItem(p_listview, name, signal, newDev->major_class,name);
//     p_listview->insertItem(bla);
//     p_listview->hideColumn(3);
}

RemoteDevice* BlueMonitor::getDetails(const QString& addr, short rssi ) {
    kdDebug() << k_funcinfo << endl;

    QString device_class(adapter->getRemoteMinorClass(addr));
    RemoteDevice *add = new RemoteDevice(addr,rssi,device_class);
    add->name = addr;
    add->version = adapter->getRemoteVersion(addr);
    if (add->version == "")
        add->version = "<i>not available</i>";
    add->manufacturer = adapter->getRemoteManufacturer(addr);
    if (add->manufacturer == "")
        add->manufacturer = "<i>not available</i>";
    add->revision = adapter->getRemoteRevision(addr);
    if (add->revision == "")
        add->revision = "<i>not available</i>";
    add->major_class = adapter->getRemoteMajorClass(addr);
    kdDebug() << "RemoteName: " << adapter->getRemoteName(addr) << endl;
    kdDebug() << "getRemoteClass: " << adapter->getRemoteClass(addr) << endl;
    kdDebug() << "getRemoteFeatures: " << adapter->getRemoteFeatures(addr) << endl;
    kdDebug() << "getRemoteServiceClasses: " << adapter->getRemoteServiceClasses(addr) << endl;

return add;

}
void BlueMonitor::getServices(RemoteDevice* add) {
    kdDebug() << k_funcinfo << endl;

    KBluetooth::Adapter::ServiceHandleList dev_serves;
    KBluetooth::Adapter::ServiceHandleList::iterator each;
    dev_serves = adapter->getRemoteServiceHandles(add->addr, "");
    for (each = dev_serves.begin(); each!= dev_serves.end(); ++each) {
        kdDebug() << "New service: " << *each << endl;
        KBluetooth::ServiceRecord record = adapter->getRemoteServiceRecord(add->addr, *each);
        add->hservices+=record;
        add->pservices.push_back( record.name() );
    }
/*
    if (!dev_serves.empty()) {	

        for (each = dev_serves.begin(); each!= dev_serves.end(); ++each) {


            KBluetooth::ServiceRecord record = adapter->getRemoteServiceRecord(add->addr, *each);
            if ((rx.search( record.name() ) < 0) && (record.name() != "")) 
                add->pservices.push_back( record.name() );

            if ( record.servId().grep("0x1124").size() >= 1) 

                add->pservices.push_back( "Human Interface Device" );

            if (add->devInfo == "" && record.typ() != "")
                add->devInfo = record.typ();



        }	
        if (!add->devInfo || add->devInfo == "" )
            add->devInfo = QString("<i>not available</i>");
    } else {
        add->pservices.push_back("no Services discovered");
//		kdDebug() << adapter->getError() << endl << endl;;
    }*/


}


void BlueMonitor::chg_name(const QString& add, const QString& name) {
    kdDebug() << k_funcinfo << endl;
    kdDebug() << "add=" << add << ", name=" << name << endl;
    BtDeviceItem *item;
    QListViewItemIterator it( p_listview );
    while ( it.current() ) {
        item = (BtDeviceItem*)(it.current());
        if(item->address() == add) {
            item->setName(name);
            return;
        }
        ++it;
    }
}


void BlueMonitor::deldev(const QString& add) {
    kdDebug() << k_funcinfo << endl;
/*
    for(it = deviceList.begin(); it!= deviceList.end(); ++it) {
            if ((**it).getAddr() == add) {
            QListViewItem *tmp = p_listview->findItem((**it).name,0,Qt::ExactMatch);
            p_listview->takeItem(tmp);
            if (deviceList.size() == 1) {
                            deviceList.clear();
                                dev_addr->setText("");
                                dev_name->setText("");
                dev_Info->setText("");
                                strength->setProgress(0);
                                dev_version->setText("");
                                dev_revision->setText("");
                                dev_manufacturer->setText("");
                                dev_category->setText("");
                                service_list->clear();
                        } else {
                if (deviceList.last() == *it) {
                    deviceList.pop_back();
                                    *it = deviceList.first();
                                    tmp = p_listview->findItem((**it).name,0,Qt::ExactMatch);
                } else {
                                    BlueMonitor::RemoteDeviceList::iterator it2 = deviceList.erase(it);
                                    tmp = p_listview->findItem((**it2).name,0,Qt::ExactMatch);
                }

                            p_listview->setSelected(tmp,true);
                                chg_details(tmp);

                        }
        break;

        }

    }*/
}

void BlueMonitor::stopDisco() {

    kdDebug() << k_funcinfo << endl;


        if (adapter->isPeriodicDiscovery() && selfstart) {
            adapter->stopPeriodicDiscovery();
            selfstart = 0;

        } else if (!adapter->isPeriodicDiscovery()) {
            adapter->startPeriodicDiscovery();
            selfstart = 1;

        } else if (adapter->isPeriodicDiscovery() && !selfstart ) { 
            connect(adapter, SIGNAL(periodicDiscoveryStopped()), this, SLOT(restartPeriodicDiscovery()));


        } else if (adapter->isPeriodicDiscovery() && !selfstart ) { 

            disconnect(adapter, SIGNAL(remoteDeviceFound(const QString&, int, short)), this, SLOT(newdev(const QString&, int, short)));
            disconnect(adapter, SIGNAL(remoteNameUpdated(const QString&, const QString&)), this, SLOT(chg_name(const QString&, const QString&)));
            disconnect(adapter, SIGNAL(remoteDeviceDisappeared(const QString&)), this, SLOT(deldev(const QString&)));
            disconnect(adapter, SIGNAL(periodicDiscoveryStopped()), this, SLOT(restartPeriodicDiscovery()));


        }

}

void BlueMonitor::chg_details(QListViewItem* sel) {
    kdDebug() << k_funcinfo << endl;
/*
    if (!sel)
        return;

    for(it = deviceList.begin(); it!= deviceList.end(); ++it) {
        if (((**it).name == sel->text(0)) && ((**it).getAddr() == sel->text(3))) {

//			kdDebug() << k_funcinfo << *it << endl;
            dev_addr->setText((**it).addr);
            dev_name->setText((**it).name);
            strength->setProgress((**it).rssi);
            dev_version->setText((**it).version);
            dev_revision->setText((**it).revision);
            dev_manufacturer->setText((**it).manufacturer);
            dev_category->setText(QString((**it).dev_class + ", " + (**it).major_class));
            dev_Info->setText((**it).devInfo);
            service_list->clear();
            for ((**it).serv_it = (**it).pservices.begin(); (**it).serv_it!=(**it).pservices.end(); ++(**it).serv_it) {

                service_list->insertItem(*(**it).serv_it);

            }

//		break;
        }

    }*/

}
void BlueMonitor::restartPeriodicDiscovery() {


    kdDebug() << "RestartPeriodicDiscovery" << endl;
    if (!adapter->isPeriodicDiscovery()) {
        adapter->startPeriodicDiscovery();
        selfstart = 1;
        disconnect(adapter, SIGNAL(periodicDiscoveryStopped()), this, SLOT(restartPeriodicDiscovery()));
    }
}
#include "bluemonitor.moc"

#endif
