/*
*
*  KDE Blutooth BlueMonitor 
*
*  Copyright (C) 2007  Tom Patzig <tpatzig@suse.de>
*  Copyright (C) 2007  Marco Gulino <marco@kmobiletools.org> (adapting to kmobiletools)
*
*  This file is part of kbluemon.
*
*  kbluemon is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  kbluemon is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with kbluemon; if not, write to the Free Software
*  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*/
#ifndef MONITOR_H
#define MONITOR_H
#include "bluetoothitems.h"

#ifdef KBLUETOOTH_NEW

#include <libkbluetooth/dbusinit.h>
#include <libkbluetooth/dbussignal.h>
#include <libkbluetooth/manager.h>
#include <libkbluetooth/adapter.h>
#include <qlayout.h>
#include <qlabel.h>
#include <time.h>
#include <qobject.h>
#include <qvaluevector.h>
#include <kprogress.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qregexp.h>

class QListView;
class RemoteDevice
{
public:
        RemoteDevice(const QString& ad,int rssi, QString& dev_class) : addr(ad), rssi(rssi), dev_class(dev_class) {}

        QString addr;
        QString name;
        int rssi;
        QString dev_class;
        QString major_class;
        QString version;
        QString revision;
        QString company;
        QString manufacturer;
        QString devInfo;
        typedef QValueVector<QString> Dev_Services;
        QValueList<KBluetooth::ServiceRecord> hservices;
        Dev_Services pservices;
        Dev_Services services() const { return pservices; }
        Dev_Services::iterator serv_it;

        void setName (QString& name) {name = name;}
        QString getAddr() {return addr;}
};

class BlueMonitor : public QObject
{
Q_OBJECT


private:
    typedef QValueVector<RemoteDevice*> RemoteDeviceList;
    RemoteDeviceList deviceList;
    RemoteDeviceList::iterator it;
    KBluetooth::Adapter *adapter;

    DBusConnection *conn;
    QString path;
    KBluetooth::Manager *manager;
    QRegExp rx;
    bool selfstart;	
    QListView *p_listview;
public:
    BlueMonitor(QListView*);
    ~BlueMonitor();
    void getServices(RemoteDevice* add);
    RemoteDevice* getDetails(const QString& addr, short rssi );

public slots:
    void newdev(const QString&, int, short);
    void chg_name(const QString&, const QString&);
    void deldev(const QString&);
    void stopDisco();
    void restartPeriodicDiscovery();
    void chg_details(QListViewItem*);

};
#endif

#endif

