/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include "bluetoothitems.h"
#include "bluemonitor.h"

#ifdef KBLUETOOTH
#include <kdebluetooth/namerequest.h>

BtDeviceItem::BtDeviceItem(KListView *parent, const KBluetooth::DeviceAddress &bdaddr)
    : KListViewItem(parent)
{
    m_bdaddr=bdaddr;
    setText(0, QString(m_bdaddr));
    setText(1, KBluetooth::NameRequest().resolve(m_bdaddr) );
}

KBluetooth::DeviceAddress BtDeviceItem::bdAddr() const { return m_bdaddr; }
KBluetooth::SDP::Device * BtDeviceItem::device() { return &m_device; }

BtServiceItem::BtServiceItem(KListView *parent, KBluetooth::SDP::Service *svc, const KBluetooth::DeviceAddress &bdaddr)
    : KListViewItem(parent)
{
    m_bdaddr=bdaddr;
    p_svc=svc;
    QString svcname, svcdesc;
    uint svcch=0;
    svc->getRfcommChannel(svcch);
    svc->getServiceName(svcname);
    svc->getServiceDescription(svcdesc);
    setText(0, QString::number(svcch) );
    setText(1, svcname );
    setText(2, svcdesc);
}
KBluetooth::DeviceAddress BtServiceItem::bdAddr() const { return m_bdaddr; }
KBluetooth::SDP::Service *BtServiceItem::service() { return p_svc; }
#endif
#ifdef KBLUETOOTH_NEW

BtDeviceItem::BtDeviceItem(KListView *parent, const QString &address, const QString &name)
    : KListViewItem(parent)
{
    setName(name);
    setAddress(address);
}

void BtDeviceItem::setName(const QString &name) {
    b_name=name;
    if(!name.isEmpty()) setText(0, name);
}

void BtDeviceItem::setAddress(const QString &addr) {
    b_addr=addr;
    if(!addr.isEmpty()) setText(1, addr);
}

RemoteDevice *BtDeviceItem::device() {
    return dev;
}

void BtDeviceItem::setDevice(RemoteDevice* device) {
    dev=device;
}

BtServiceItem::BtServiceItem(KListView *parent, const KBluetooth::ServiceRecord& service)
    : KListViewItem(parent)
{
    p_service=service;
    kdDebug() << "BtServiceItem: service number=" << p_service.rfcommChannel() << ", name=" << p_service.name() << endl;
    setText(0, QString::number(p_service.rfcommChannel()) );
    setText(1, p_service.name() );
//     setText(0, QString::fromInt(p_service.rfcommChannel()));
}

#endif
