/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include <kmessagebox.h>
#include <klocale.h>
#include <klineedit.h>
#include <kconfigskeleton.h>
#include <qbuttongroup.h>
#include <kdebug.h>
#include <knuminput.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <kapplication.h>
#include <kcombobox.h>
#include <qtabwidget.h>
#include <kpushbutton.h>
#include <math.h>
#include <keditlistbox.h>
#include <klocale.h>
#include <klistview.h>
#include <kstandarddirs.h>
#include <qstringlist.h>
#include <qwidgetstack.h>
#include <kplugininfo.h>
#include <kactivelabel.h>
#include <kiconloader.h>
#include <qsqlpropertymap.h>

#include "engineslist.h"
#include "kmobiletoolshelper.h"
#include "deviceconfigdialog.h"
#include "wizDeviceFirst.h"
#include "cfg_at-engine.h"
#ifdef WITH_GAMMU
#include "cfg_gammu-engine.h"
#endif
#include "genericDeviceOptions.h"
#include "deviceIFace_stub.h"
#include "picksmscenter.h"

#include "cfg_filesystem.h"
#include "keycombobox.h"

#define CONN_USB            1
#define CONN_USB_ID         0
#define CONN_IRDA           2
#define CONN_IRDA_ID        1
#define CONN_BLUETOOTH      4
#define CONN_BLUETOOTH_ID   2
#define CONN_SERIAL         8
#define CONN_SERIAL_ID      3

using namespace KMobileTools;

deviceConfigDialog::deviceConfigDialog(QWidget *parent, const char *name, KConfigSkeleton *config, DialogType dialogType, int dialogButtons, ButtonCode defaultButton, bool modal)
    : KConfigDialog(parent, name, config, dialogType, Ok|Apply|Cancel , defaultButton, modal )
{
    (void) dialogButtons;
    at_selected_connections=0;
    firstPage=new wizDeviceFirst();
    QValueList<KPluginInfo*> engines=EnginesList::instance()->availEngines();
    for(QValueList<KPluginInfo*>::iterator it=engines.begin(); it!=engines.end(); ++it)
        firstPage->kcfg_engine->insertItem((*it)->name(), (*it)->service()->library() );

    at_engine=new cfg_at_engine();
#ifdef ENABLE_FS
    fsConfig=new cfgFilesystem();
#else
    fsConfig=new QLabel(i18n("Support for filesystem is currently disabled. To reenable it, look KMobileTools documentation on our homepage, and run configure with the correct flags."), NULL);
    fsConfig->setAlignment(Qt::AlignLeft | Qt::AlignTop | Qt::WordBreak);
#endif

#ifdef ENABLE_FS
    #ifndef HAVE_OBEXFTP
        fsConfig->kcfg_fstype->changeItem(fsConfig->kcfg_fstype->text(2).append(i18n(" - not compiled")), 2);
    #endif
    #ifndef HAVE_P2KLIB
        fsConfig->kcfg_fstype->changeItem(fsConfig->kcfg_fstype->text(1).append(i18n(" - not compiled")), 1);
    #endif
#endif
    genOptions=new genericDeviceOptions();
    addPage(firstPage, i18n("Name and type"), "blockdevice" );
    addPage(genOptions, i18n("Device Options"), "kmobiletools");
    addPage(at_engine, i18n("AT Engine"), "kmobiletools");
    addPage(fsConfig, i18n("Files Access"), "folder_yellow");

#ifdef WITH_GAMMU
    gammu_engine=new cfg_gammu_engine();
    addPage(gammu_engine, i18n("Gammu Engine"), "kmobiletools");
    QString infoText = i18n("Please refer to <a href=\"http://cihar.com/gammu/phonedb/\">"
                       "http://cihar.com/gammu/phonedb/</a> for the right phone parameters!<br>"
                       "<strong>Hint: </strong>Some connections require the port to be set to your "
                       "bluetooth address instead of the rfcomm device.");
    gammu_engine->infoPixmap->setPixmap(
                  KGlobal::iconLoader()->loadIcon("messagebox_info", KIcon::Desktop, 32 )
    );
    gammu_engine->infoText->setText( infoText );
#endif

    connect(firstPage->kcfg_engine, SIGNAL(activated(const QString &) ), this, SLOT(slotEngineChanged(const QString & ) ) );
    connect(genOptions->kcfg_status_poll, SIGNAL(toggled(bool) ), this, SLOT(slotPollEnabled(bool ) ) );
    connect( at_engine->b_advopts_details, SIGNAL(clicked() ), this, SLOT(at_advancedOptions() ) );
    connect(at_engine->bg_devtype, SIGNAL(clicked( int ) ), this, SLOT(at_connectionClicked( int ) ));
    connect(genOptions->b_smscenter_choose, SIGNAL(clicked()), this, SLOT(chooseSMSCenter()));
#ifdef ENABLE_FS
    connect(fsConfig->kcfg_fstype, SIGNAL(activated(int)), this, SLOT(fs_selected( int )));
#endif
    genOptions->kcfg_verbose->setText(genOptions->kcfg_verbose->text().arg(KGlobal::dirs()->saveLocation("tmp", "kmobiletools", true)) );
    slotEngineChanged( DeviceConfigInstance(name)->engine() );
    slotPollEnabled( DeviceConfigInstance(name)->status_poll() );
//     DeviceIFace_stub *deviceiFace=new DeviceIFace_stub( kapp->dcopClient(), "kmobiletools", name );
//     QStringList encodings=deviceiFace->encodings();
    QStringList encodings=DeviceConfigInstance(name)->at_availencodings();
    at_engine->advoptstab->hide();
    at_engine->b_advopts_details->setText(i18n( "Details >>"));
    at_engine->advoptstab->resize( 0,0 );
    at_engine->resize( at_engine->minimumSizeHint() );
//     at_advancedOptions();
    if (! encodings.isEmpty() )
    {
        at_engine->kcfg_at_encoding->clear();
        at_engine->kcfg_at_encoding->insertStringList(encodings);
    }
    QStringList sl_slots;
    QCheckListItem *tempItem;
    sl_slots=DeviceConfigInstance(name)->at_availpbslots();
    for ( QStringList::Iterator it=sl_slots.begin(); it!=sl_slots.end(); ++it)
    {
        tempItem=new QCheckListItem(at_engine->slots_phonebook, QString(*it), QCheckListItem::CheckBox);
        if( DeviceConfigInstance(name)->at_pbslots().findIndex( *it ) >=0 ) tempItem->setState(QCheckListItem::On);
        tempItem->setText(1, KMobiletoolsHelper::memorySlotsDescriptions(*it, KMobiletoolsHelper::PhoneBook) );
    }
    sl_slots=DeviceConfigInstance(name)->at_availsmsslots();
    for ( QStringList::Iterator it=sl_slots.begin(); it!=sl_slots.end(); ++it)
    {
        tempItem=new QCheckListItem(at_engine->slots_sms, QString(*it), QCheckListItem::CheckBox);
        if( DeviceConfigInstance(name)->at_smsslots().findIndex( *it ) >=0 ) tempItem->setState(QCheckListItem::On);
        tempItem->setText(1, KMobiletoolsHelper::memorySlotsDescriptions(*it, KMobiletoolsHelper::SMS) );
    }

    if(DeviceConfigInstance(name)->at_usb() ) at_selected_connections |= KMobileTools::KMobiletoolsHelper::USB;
    if(DeviceConfigInstance(name)->at_irda() ) at_selected_connections |= KMobileTools::KMobiletoolsHelper::IRDA;
    if(DeviceConfigInstance(name)->at_bluetooth() ) at_selected_connections |= KMobileTools::KMobiletoolsHelper::Bluetooth;
    if(DeviceConfigInstance(name)->at_serial() ) at_selected_connections |= KMobileTools::KMobiletoolsHelper::Serial;
    fs_selected(DeviceConfigInstance(name)->fstype());
    updateWidgets();
}


deviceConfigDialog::~deviceConfigDialog()
{
}

void deviceConfigDialog::fs_selected(int item)
{
    kdDebug() << "Filesystem ID: "<< item << endl;
#ifdef ENABLE_FS
    fsConfig->fs_stack->raiseWidget(item);
#endif
}


#include "deviceconfigdialog.moc"

void deviceConfigDialog::updateSettings()
{
    KConfigDialog::updateSettings();
}

void deviceConfigDialog::slotOk()
{
    if( firstPage->kcfg_devicename->text().length() )
    {
        saveSlots();
        KConfigDialog::slotOk();
    }
    else
        KMessageBox::error(this, i18n("You must enter a name for your device"), i18n("Error") );
}
void deviceConfigDialog::slotApply()
{
    if( firstPage->kcfg_devicename->text().length() )
    {
        saveSlots();
        KConfigDialog::slotApply();
    }
    else
        KMessageBox::error(this, i18n("You must enter a name for your device"), i18n("Error") );
}


/*!
    \fn deviceConfigDialog::slotEngineChanged(int id)
 */
void deviceConfigDialog::slotEngineChanged(const QString &enginename)
{
    /// @TODO remove this hardcoded part.
    uint id;
    if(enginename=="AT Engine" || enginename=="libkmobiletools_at") id=0;
    if(enginename=="Gammu Engine" || enginename=="libkmobiletools_gammu") id=1;
    switch( id ){
#ifdef WITH_GAMMU
        case 1:
            gammu_engine->setEnabled(true);
            at_engine->setEnabled(false);
        break;
#endif
        case 0:
        default:
            at_engine->setEnabled(true);
#ifdef WITH_GAMMU
            gammu_engine->setEnabled(false);
#endif
        break;
    }
}

void deviceConfigDialog::slotPollEnabled(bool poll)
{
    if(poll)
    {
        genOptions->poll2Label->setEnabled(true);
        genOptions->kcfg_status_pollTimeout->setEnabled(true);
        return;
    }
    genOptions->poll2Label->setEnabled(false);
    genOptions->kcfg_status_pollTimeout->setEnabled(false);
}


/*!
    \fn deviceConfigDialog::at_advancedOptions()
 */
void deviceConfigDialog::at_advancedOptions()
{
    if( at_engine->advoptstab->isVisible() )
    {
        at_engine->advoptstab->hide();
        at_engine->b_advopts_details->setText(i18n("Details >>"));
        at_engine->advoptstab->resize( 0,0 );
        at_engine->resize( at_engine->minimumSizeHint() );
    } else
    {
        at_engine->advoptstab->show();
        at_engine->b_advopts_details->setText(i18n("Details <<"));
        at_engine->advoptstab->resize(at_engine->advoptstab->minimumSize());

    }
}


/*!
    \fn deviceConfigDialog::at_connectionClicked(int index)
 */
void deviceConfigDialog::at_connectionClicked(int index)
{
    if( at_engine->bg_devtype->find( index )->state() == QButton::On) at_selected_connections|= index;
    else at_selected_connections&= ~index;
    at_engine->kcfg_atdevices->setItems(KMobileTools::KMobiletoolsHelper::getStdDevices(at_selected_connections, at_engine->kcfg_atdevices->items() ) );
}


/*!
    \fn deviceConfigDialog::saveSlots()
 */
void deviceConfigDialog::saveSlots()
{
    QStringList tmp_slots;
    QListViewItemIterator it(at_engine->slots_sms, QListViewItemIterator::Checked);
    KMobileTools::DevicesConfig *wconfig=KMobileTools::DevicesConfig::prefs( name() );
    while(it.current() )
    {
        tmp_slots+=(*it)->text(0);
        ++it;
    }
    wconfig->setAt_smsslots( tmp_slots);
    tmp_slots.clear();
    QListViewItemIterator it2(at_engine->slots_phonebook, QListViewItemIterator::Checked);
    while(it2.current() )
    {
        tmp_slots+=(*it2)->text(0);
        ++it2;
    }
    wconfig->setAt_pbslots( tmp_slots);
    wconfig->writeConfig();
}


/*!
    \fn deviceConfigDialog::chooseSMSCenter()
 */
void deviceConfigDialog::chooseSMSCenter()
{
    PickSMSCenter *dlg=new PickSMSCenter(this);
    dlg->exec();
    if(dlg->smsCenter() != QString::null ) genOptions->kcfg_smscenter->setText(dlg->smsCenter() );
}
