/* This file is part of the KDE project
   Copyright (c) 2004 Kevin Ottens <ervin ipsquad net>
   Rearranged by Marco Gulino <marco@kmobiletools.org> for the mobile protocol

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef _mobile_H_
#define _mobile_H_

#include <qstring.h>
#include <qcstring.h>

#include <kurl.h>
#include <kio/global.h>
#include <kio/slavebase.h>
#include <dcopclient.h>

#include "mobileimpl.h"

class QCString;

class kio_mobileProtocol : public KIO::SlaveBase
{
public:
    kio_mobileProtocol(const QCString &pool_socket, const QCString &app_socket);
    virtual ~kio_mobileProtocol();
//     virtual void mimetype(const KURL& url);
//     virtual void get(const KURL& url);
    virtual void listDir(const KURL &url);
    virtual void stat(const KURL &url);

    private:
        DCOPClient m_dcop;
        void listRoot();
        MobileImpl m_impl;
};

#endif
