/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2004
*/

#ifndef KMFCONFIGDIALOG_H
#define KMFCONFIGDIALOG_H

#include <qwidget.h>
#include <kdialogbase.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kprocess.h>
#include <qstring.h>
#include <qpixmap.h>


#include "core/kmfcompilerinterface.h"

class QFrame;
class QCheckBox;
class QRadioButton;
class QButtonGroup;
class KURLRequester;
class KPushButton;
class KComboBox;
class KListBox;
class KIntSpinBox;

namespace KMF {
class KMFCheckListOutput;
class KMFInterfaceWidget;
class KMFMyNetworkWidget;
class KMFNetwork;
class KMFGenericInterfaceEditProtocol;

class KMFConfigDialog : public KDialogBase {
	Q_OBJECT

public:
	KMFConfigDialog( QWidget *parent = 0, const char *name = 0, bool modal = true );
	~KMFConfigDialog();
	void setNetwork( KMFNetwork* );
	void registerCompiler( KMFCompilerInterface* );
	void convertConfig();
	void exec();
	
public slots:
	void slotReadConfig();
	void slotSaveConfig();

private slots:
	void slotEnableGenericInterface( bool );
	void slotEnableWarnings();
	// void slotEnableLocalSSHUsage( bool enable );
	void slotApply();
	void accept();
	void reject();
	
private:  // members
	void setupListView();
	void setupGeneral();
	void setupCustomProtocols();
	void setupPlugins();
	void checkPlugins();
	void loadIcons();

private:  // data
	KMFNetwork *m_network;

	// General
	QCheckBox *m_cb_show_splash;
	QCheckBox *m_cb_show_selInterface;
	QCheckBox *m_cb_generic_interface;
	QCheckBox *m_cb_useSSHForLocalhost;
	KIntSpinBox *m_sb_max_undo;
	KPushButton *m_b_enable_warnings;

	KMFGenericInterfaceEditProtocol *m_protocolPageEditProtocol;
	
	// Path widget
 	QPtrList<QStringList> *m_backends;


	QPixmap icon_paths, icon_interfaces, icon_general, icon_listview, icon_edit_protocol_page;
	QFrame * pageGeneric;
	
	// ListView
	QCheckBox *m_cb_show_cmds;
	QCheckBox *m_cb_show_desc;
	QCheckBox *m_cb_show_objectID;
	QLabel *m_lvp_text1, *m_lvp_text2, *m_lvp_text3;
	
	// Plugins
	KListView *m_lv_plugins;
signals:
	void sigConfigChanged();
};
}
#endif
