/* KNetmap - KDE Network Mapper
 *
 * Copyright (C) 2003 Joshua T. Corbin <jcorbin@linuxmail.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef KLISTVIEWOBJECT_H
#define KLISTVIEWOBJECT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 
#include <qobject.h>
#include <qstring.h>
#include <klistview.h>

class KListViewObject : public QObject, public KListViewItem
{
  Q_OBJECT
public:
  KListViewObject(QListView *parent);
  KListViewObject(QListViewItem *parent);
  KListViewObject(QListView *parent, QListViewItem *after);
  KListViewObject(QListViewItem *parent, QListViewItem *after);
  KListViewObject(QListView *parent, QString, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null);
  KListViewObject(QListViewItem *parent, QString, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null);
  KListViewObject(QListView *parent, QListViewItem *after, QString, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null);
  KListViewObject(QListViewItem *parent, QListViewItem *after, QString, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null);

  QObject *represents() const {return m_rep;};
  void setRepresents(QObject *);

  virtual int rtti() const {return 1001;};

protected:
  QObject *m_rep;
};

#endif // KLISTVIEWOBJECT_H
