/* KNetmap - KDE Network Mapper
 *
 * Copyright (C) 2003 Joshua T. Corbin <jcorbin@linuxmail.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef KNETMAP_H
#define KNETMAP_H
 
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kaction.h>
#include <kurl.h>
#include <kfiledialog.h>
#include <qptrlist.h>
#include <qstringlist.h>

class KNetmapView;
class KNetmapDoc;
class KNetmapConsole;
class KNetmapScanWidget;

class KNetmapApp : public KMainWindow
{
  Q_OBJECT

  friend class KNetmapView;
  friend class KNetmapDoc;

public:
  KNetmapApp(QWidget* parent=0, const char* name=0);
  ~KNetmapApp();
  void openDocumentFile(const KURL& url=0);
  KNetmapDoc *getDocument() const; 	
  KNetmapConsole *getConsole() const {return console;};
  KNetmapScanWidget *scanWidget() const {return m_scanWidget;};
  bool autoopen() const;
  const QStringList rootCmd() const;

public slots:
  void setAutoopen(bool);
  void setRootCmd(const QStringList &);
  void setRootCmd(const QString &);
  void setConsoleShown(bool);
  void slotFileNew();
  void slotFileOpen();
  void slotFileOpenRecent(const KURL& url);
  void slotFileSave();
  void slotFileSaveAs();
  void slotFileQuit();
  void slotViewToolBar();
  void slotViewStatusBar();
  void slotViewConsole();
  void slotStatusMsg(const QString &text);
  void optionsConfigureKeys();
  void optionsConfigureToolbars();
  void updateGUI();
  void optionsPreferences();
  void changeState(QString);

protected:
  void saveOptions();
  void readOptions();
  void initActions();
  void initStatusBar();
  void initView();
  virtual bool queryClose();
  virtual bool queryExit();
  virtual void saveProperties(KConfig *);
  virtual void readProperties(KConfig *);

private:
  int sub_menu_id, host_menu_id;
  KConfig *config;
  KNetmapView *view;
  KNetmapDoc *doc;
  bool m_lastdoc;

  // KAction pointers to enable/disable actions
  KAction *scanwidgetAdd;
  KAction *fileNew;
  KAction *fileOpen;
  KRecentFilesAction *fileOpenRecent;
  KAction *fileSave;
  KAction *fileSaveAs;
  KAction *fileQuit;
  KToggleAction *viewToolBar;
  KToggleAction *viewStatusBar;
  KToggleAction *viewConsole;
  KWidgetAction *scanAction;
  KAction *deleteSelected;

  KNetmapConsole *console;
  KNetmapScanWidget *m_scanWidget;

  QStringList m_rootcmd;
};
 
#endif // KNETMAP_H
