/* KNetmap - KDE Network Mapper
 *
 * Copyright (C) 2003 Joshua T. Corbin <jcorbin@linuxmail.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <qlabel.h>
#include <qpushbutton.h>
#include <kglobal.h>
#include <kiconloader.h>

#include "knetmapconsole.h"
#include "knetmapview.h"
#include "knetmap.h"

KNetmapConsole::KNetmapConsole(QWidget *parent, const char *name)
  : QWidget(parent, name)
{
  QVBoxLayout *top_layout = new QVBoxLayout(this);
  top_layout->setAutoAdd(TRUE);

  tab = new QTabWidget(this);
  //  tab->setTabPosition(QTabWidget::Bottom);
}

KNetmapConsole::~KNetmapConsole()
{
}

KNetmapApp *KNetmapConsole::getApp()
{
  return ((KNetmapView *)parent()->parent())->getApp();
}

////////////////////////////////////////////////////////////
KNetmapConsolePage::KNetmapConsolePage(KNetmapConsole *console,
				       const QString &label,
				       const QString &tip,
				       const char *name,
				       const char *iconame)
  : QWidget(0, name) //console->tab, name)
{
  m_console = console;
  m_icon    = iconame;
  m_label   = label;
  m_tip     = tip;

  QVBoxLayout *top_layout = new QVBoxLayout(this);
  top_layout->setAutoAdd(TRUE);

  // Title row
  QWidget *row = new QWidget(this);
  QHBoxLayout *row_layout = new QHBoxLayout(row);
  row_layout->setAutoAdd(TRUE);
  QLabel *icon = new QLabel(row);
  QLabel *title = new QLabel(row);
  icon->setPixmap(KGlobal::iconLoader()->loadIcon(iconame, KIcon::NoGroup, 48));
  icon->setFixedWidth(52);
  title->setText(tip);
  row->setFixedHeight(52);
}

KNetmapConsolePage::~KNetmapConsolePage()
{
  if ((m_console->tab->count() == 1) && m_console->isShown())
    m_console->getApp()->setConsoleShown(false);
}

void KNetmapConsolePage::addToConsole()
{
  m_console->tab->addTab(this, KGlobal::iconLoader()->loadIconSet(m_icon, KIcon::Small), m_label);
  if (!m_tip.isEmpty())
    m_console->tab->setTabToolTip(this, m_tip);
  if (m_console->tab->count() && m_console->isHidden())
    m_console->getApp()->setConsoleShown(true);
}

#include "knetmapconsole.moc"
