/* KNetmap - KDE Network Mapper
 *
 * Copyright (C) 2003 Joshua T. Corbin <jcorbin@linuxmail.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef KNETMAPCONSOLE_H
#define KNETMAPCONSOLE_H
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 
#include <qwidget.h>
#include <qlayout.h>
#include <qobject.h>
#include <qtabwidget.h>

class KNetmapConsolePage;
class KNetmapApp;

class KNetmapConsole : public QWidget
{
  Q_OBJECT
public:
  KNetmapConsole(QWidget *parent=0, const char *name=0);
  ~KNetmapConsole();
  KNetmapApp *getApp();

  friend class KNetmapConsolePage;

private:
  QTabWidget *tab;
};

class KNetmapConsolePage : public QWidget
{
  Q_OBJECT
public:
  KNetmapConsolePage(KNetmapConsole *,
		     const QString &, const QString &,
		     const char *,    const char *);
  ~KNetmapConsolePage();
  virtual int rtti() const {return 0;};

protected:
  void addToConsole();

private:
  KNetmapConsole *m_console;
  QString m_icon;
  QString m_label;
  QString m_tip;
};

#endif // KNETMAPCONSOLE_H
