/* KNetmap - KDE Network Mapper
 *
 * Copyright (C) 2003 Joshua T. Corbin <jcorbin@linuxmail.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef KNETMAPDOC_H
#define KNETMAPDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qptrlist.h>
#include <qdom.h>

// include files for KDE
#include <kurl.h>

// forward declaration of the KNetmap classes
class KNetmapView;
class KNetmapSubnet;
class KNetmapHost;
class KNetmapApp;
class IPv4;

class KNetmapDoc : public QObject
{
  Q_OBJECT
public:
  KNetmapDoc(QWidget *parent, const char *name=0);
  ~KNetmapDoc();

  void addView(KNetmapView *view);
  void removeView(KNetmapView *view);
  void setModified(bool=true);
  bool isModified() {return modified;};
  bool saveModified();	
  void deleteContents();
  bool newDocument();
  void closeDocument();
  bool openDocument(const KURL& url);
  bool saveDocument(const KURL& url);
  const KURL& URL() const;
  void setURL(const KURL& url);
  KNetmapSubnet *subForIP  (const IPv4 &, bool=false);
  KNetmapSubnet *findSubnet(const IPv4 &);
  KNetmapHost   *findHost  (const IPv4 &);
  KNetmapHost   *addHost   (const IPv4 &);
  QObject *current() const {return m_cur;};
  KNetmapApp *getApp() const {return (KNetmapApp *)parent();};
  const QPtrList<KNetmapHost> selectedHosts() const;
  const QPtrList<KNetmapSubnet> selectedSubnets() const;

signals:
  void subnetAdded(KNetmapSubnet *);
  void currentChanged(QObject *);

public slots:
  void slotUpdateAllViews(KNetmapView *);
  void setCurrent(QObject *);
  void deleteCurrent();
  void deleteSelected();
  void slotSetModified();
  void setSelectedHosts(const QPtrList<KNetmapHost> &);
  void setSelectedSubnets(const QPtrList<KNetmapSubnet> &);

public:	
  KNetmapView *findView(const QString &);
  static QPtrList<KNetmapView> *pViewList;	

protected:
  virtual void childEvent(QChildEvent *);

private:
  bool modified;
  KURL doc_url;
  QObject *m_cur;
  QPtrList<KNetmapHost> m_curHosts;
  QPtrList<KNetmapSubnet> m_curSubs;
  int m_ccount;
};

#endif // KNETMAPDOC_H
