/* KNetmap - KDE Network Mapper
 *
 * Copyright (C) 2003 Joshua T. Corbin <jcorbin@linuxmail.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <qstringlist.h>
#include <klocale.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <qcheckbox.h>
#include <qregexp.h>

#include "knetmappref.h"
#include "knetmapgeneralprefpage.h"
#include "knetmap.h"

static const QRegExp r_whitespace("\\s+");
static const QString s_kdesucmd("kdesu -t --");
static const QString s_sudocmd("sudo -H");

KNetmapGeneralPrefPage::KNetmapGeneralPrefPage(KNetmapPreferences *prefs)
  : KNetmapGeneralPrefs(prefs->vboxPage(i18n("General"), i18n("General Options"), "configure"), "generalPrefs")
{
  QString cmd;
  if (!prefs->getApp()->rootCmd().empty())
    {
      cmd = prefs->getApp()->rootCmd().join(" ");
    }
  else
    {
      prefs->getApp()->setRootCmd(s_kdesucmd);
      cmd = s_kdesucmd;
    }

  if (cmd == s_kdesucmd)
    rootPrivCombo->setCurrentItem(KDESu);
  else if (cmd == s_sudocmd)
    rootPrivCombo->setCurrentItem(Sudo);
  else
    rootPrivCombo->setCurrentItem(Custom);

  autoOpenCheck->setChecked(prefs->getApp()->autoopen());
  custCmdEntry->setText(prefs->getApp()->rootCmd().join(" "));

  connect(rootPrivCombo, SIGNAL(activated(int)),
	  this, SLOT(slotRootPrivComboActivated(int)));
  connect(custCmdEntry, SIGNAL(textChanged(const QString &)),
	  prefs->getApp(), SLOT(setRootCmd(const QString &)));
  connect(autoOpenCheck, SIGNAL(toggled(bool)),
	  prefs->getApp(), SLOT(setAutoopen(bool)));
}

KNetmapGeneralPrefPage::~KNetmapGeneralPrefPage()
{
}

void KNetmapGeneralPrefPage::slotRootPrivComboActivated(int i)
{
  switch (i)
    {
    case KDESu:
      custCmdEntry->setText(s_kdesucmd);
      break;
    case Sudo:
      custCmdEntry->setText(s_sudocmd);
      break;
    case Custom:
      custCmdEntry->setText(QString::null);
      break;
    };
}

#include "knetmapgeneralprefpage.moc"
