/* KNetmap - KDE Network Mapper
 *
 * Copyright (C) 2003 Joshua T. Corbin <jcorbin@linuxmail.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef KNETMAPHOSTPAGE_H
#define KNETMAPHOSTPAGE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 
#include <qwidget.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qtabwidget.h>
#include <klistview.h>
#include <ktextedit.h>
#include "klistviewobject.h"

class KNetmapApp;
class KNetmapHost;
class KNetmapPort;
class KNetmapOS;

class KNetmapHostPage : public QWidget
{
  Q_OBJECT
public:
  KNetmapHostPage(QWidget *parent=0, const char *name=0);
  ~KNetmapHostPage();
  KNetmapHost *host() const {return m_host;};
  KNetmapApp *getApp();

public slots:
  void update(QObject *);
  void addOS(KNetmapOS *);
  void addPort(KNetmapPort *);
  void setName(const QString &);
  void setIcon(const QString &);
  void updateInfo();

private:
  KNetmapHost *m_host;
  QVBoxLayout *top_layout;
  QLabel      *m_icon;
  QLabel      *m_lbl;
  QLabel      *m_os;
  //   KListView   *m_os;
  KListView   *m_ports;
  QTabWidget  *m_tabs;
  KTextEdit   *m_info;
};

class KNetmapPortItem : public KListViewObject
{
  Q_OBJECT
public:
  KNetmapPortItem(QListView *, KNetmapPort *port);
  virtual int compare (QListViewItem *, int, bool) const;

public slots:
  void updateInfo();
};

#endif // KNETMAPHOSTPAGE_H

