/* KNetmap - KDE Network Mapper
 *
 * Copyright (C) 2003 Joshua T. Corbin <jcorbin@linuxmail.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef KNETMAPNMAPPARSER_H
#define KNETMAPNMAPPARSER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qstring.h>
#include <qobject.h>
#include <qptrlist.h>
#include <qxml.h>
#include <kdirwatch.h>

class KNetmapApp;
class KNetmapNmapScan;
class KNetmapNmapScanner;
class KNetmapNmapXMLHandler;
class KNetmapHost;
class KNetmapPort;

class KNetmapNmapParser : public QObject
{
  Q_OBJECT
public:
  friend class KNetmapNmapXMLHandler; // TODO fix this.
  KNetmapNmapParser(KNetmapNmapScan *);
  KNetmapNmapParser(KNetmapNmapScanner *, const QString &);
  ~KNetmapNmapParser();
  KNetmapApp *getApp() const {return theApp;};
  void parse();
  const QString errorString() const {return errstr;};

signals:
  void parseDone();
  void parseFailed();

protected slots:
  void slotDirty(const QString &);

protected:
  void doParseDone();

private:
  bool parseIter();
  bool xmlWarning;
  bool xmlError;
  bool xmlFatalError;
  QString errstr;

  KNetmapApp *theApp;

  QString filename;
  QFile *file;
  // KDirWatch *watcher;

  QXmlInputSource *xmlSource;
  QXmlSimpleReader *xmlReader;
  KNetmapNmapXMLHandler *xmlHandler;

  bool started;
};

class KNetmapNmapXMLHandler : public QXmlDefaultHandler
{
public:
  KNetmapNmapXMLHandler(KNetmapNmapParser *);
  bool startElement(const QString &, const QString &,
		    const QString &, const QXmlAttributes &);
  bool endElement(const QString &, const QString &, const QString &);

  virtual bool warning (const QXmlParseException &);
  virtual bool error (const QXmlParseException &);
  virtual bool fatalError (const QXmlParseException &);
  unsigned int startTime() const;
  unsigned int endTime() const;

private:
  KNetmapNmapParser *parser;
  KNetmapHost *host;
  KNetmapPort *port;
  bool inHost;
  bool inPort;
  bool hostUp;
  bool firstOS;
  unsigned int m_stime;
  unsigned int m_etime;
//   QString args;
};

#endif // KNETMAPNMAPPARSER_H
