/* KNetmap - KDE Network Mapper
 *
 * Copyright (C) 2003 Joshua T. Corbin <jcorbin@linuxmail.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef KNETMAPNMAPPREFPAGE_H
#define KNETMAPNMAPPREFPAGE_H

#include "knetmapnmapprefs.h"

class KNetmapNmapScanner;
class KNetmapNmapProfile;
class KNetmapPreferences;

class KNetmapNmapPrefPage : public KNetmapNmapPrefs
{
  Q_OBJECT
public:
  KNetmapNmapPrefPage(KNetmapNmapScanner *, KNetmapPreferences *);
  ~KNetmapNmapPrefPage();
  KNetmapNmapScanner *scanner() const {return m_scanner;};

  // The following enums are here to match the entries in combo boxen.
  enum e_scanTypeCombo
    {
      ScanConnect=0,
      ScanSYN,
      ScanACK,
      //     scanFINACK,
      ScanFIN,
      ScanNULL,
      ScanXMas,
      ScanTCPWin,
      ScanIdle
    };

  enum e_scanPorts
    {
      portsDefault, // Nothing
      portsAll,     // -p-
      portsFast,    // -F
      portsRange    // -p ...
    };

  enum e_timings
    {
      paranoidTiming=0,
      sneakyTiming,
      politeTiming,
      normalTiming,
      aggressiveTiming,
      insaneTiming
    };

  enum e_optRDNS
    {
      rdnsAlways=0,
      rdnsReq,
      rdnsNever
    };
  
public slots:
  void scanUDP_toggled(bool);
  void setScannerUI();
  void profileChanged(QListViewItem *);
  void profileChanged(KNetmapNmapProfile *);
  void cliEntry_lostFocus();
  void updateCLI();
  void setSourceIface(bool);
  void setSourcePort(bool);
  void setSourceIP(bool);
  void updateDecoys();
  void newProfile_clicked();
  void delProfile_clicked();
  void defProfile_toggled(bool);
  void profEntry_textChanged(const QString &);
  void updateVersion(const QString &);
  void setScanType(int);
  void setScanPorts(int);
  void setRPCScan(bool);
  void setIdentdScan(bool);
  void setVersionScan(bool);
  void setOSScan(bool);
  void setNoPing(bool);
  void setACKPing(bool);
  void setSYNPing(bool);
  void setUDPPing(bool);
  void setEchoPing(bool);
  void setTStampPing(bool);
  void setMaskPing(bool);
  void timParMinToggled(bool);
  void timParMaxToggled(bool);
  void timRttInitToggled(bool);
  void timRttMinToggled(bool);
  void timRttMaxToggled(bool);
  void timTTLToggled(bool);
  void timHTimeToggled(bool);
  void timDelayToggled(bool);
  void setRDNS(int);
  void optPLoadToggled(bool);
  void optSockToggled(bool);
  void setOSLimit(bool);
  void setFrag(bool);
  void setRandHost(bool);
  void setRandPort(bool);
  void resizeMePlease();
  void tabSwitched(QWidget *);

private:
  KNetmapNmapScanner *m_scanner;
  KNetmapNmapProfile *m_profile;
  KNetmapPreferences *m_prefs;
  QString m_oldstr;
};

#endif // KNETMAPNMAPPREFPAGE_H
