/****************************************************************************
 ** ui.h extension file, included from the uic-generated form implementation.
 **
 ** If you wish to add, delete or rename functions or slots use
 ** Qt Designer which will update this file, preserving your code. Create an
 ** init() function in place of a constructor, and a destroy() function in
 ** place of a destructor.
 *****************************************************************************/

#include <kglobal.h>
#include <kiconloader.h>

enum e_scanTypeCombo
  {
    ScanConnect=0,
    ScanSYN,
    ScanACK,
//     scanFINACK,
    ScanFIN,
    ScanNULL,
    ScanXMas,
    ScanTCPWin,
    ScanIdle
  };

enum e_scanPorts
  {
    portsDefault,
    portsAll,
    portsFast,
    portsRange
  };

void KNetmapNmapPrefs::scanPortsCombo_activated( int i )
{
  scanPortsRangeLabel->setEnabled(i == portsRange);
  scanPortsRangeEntry->setEnabled(i == portsRange);
}

void KNetmapNmapPrefs::discDontPing_toggled( bool b )
{
  discPingTypes->setEnabled(!b);
}

void KNetmapNmapPrefs::discACKCheck_toggled( bool b )
{
  discACKLabel->setEnabled(b);
  discACKPorts->setEnabled(b);
}

void KNetmapNmapPrefs::discSYNCheck_toggled( bool b )
{
  discSYNLabel->setEnabled(b);
  discSYNPorts->setEnabled(b);
}

void KNetmapNmapPrefs::discUDPCheck_toggled( bool b )
{
  discUDPLabel->setEnabled(b);
  discUDPPorts->setEnabled(b);
}

void KNetmapNmapPrefs::timParMinCheck_toggled( bool b )
{
  timParMinValue->setEnabled(b);
}

void KNetmapNmapPrefs::timParMaxCheck_toggled( bool b )
{
  timParMaxValue->setEnabled(b);
}

void KNetmapNmapPrefs::timRttInitCheck_toggled( bool b )
{
  timRttInitValue->setEnabled(b);
}
void KNetmapNmapPrefs::timRttMinCheck_toggled( bool b )
{
  timRttMinValue->setEnabled(b);
}
void KNetmapNmapPrefs::timRttMaxCheck_toggled( bool b )
{
  timRttMaxValue->setEnabled(b);
}
void KNetmapNmapPrefs::timTTLCheck_toggled( bool b )
{
  timTTLValue->setEnabled(b);
}
void KNetmapNmapPrefs::timHTimeCheck_toggled( bool b )
{
  timHTimeValue->setEnabled(b);
}
void KNetmapNmapPrefs::timDelayCheck_toggled( bool b )
{
  timDelayValue->setEnabled(b);
}
void KNetmapNmapPrefs::optRDNSCheck_toggled( bool b )
{
  optRDNSCombo->setEnabled(b);
}
void KNetmapNmapPrefs::optPLoadCheck_toggled( bool b )
{
  optPLoadValue->setEnabled(b);
}
void KNetmapNmapPrefs::optSockCheck_toggled( bool b )
{
  optSockValue->setEnabled(b);
}
void KNetmapNmapPrefs::scanOS_toggled( bool b )
{
  optOSLimit->setEnabled(b);
}
void KNetmapNmapPrefs::decUse_toggled( bool b )
{
  decList->setEnabled(b);
  decNew->setEnabled(b);
  decEntry->setEnabled(b);
  if (b)
  {
    decList_selectionChanged(decList->selectedItem());
  }
  else
  {
    decDel->setEnabled(false);
    decUp->setEnabled(false);
    decDown->setEnabled(false);
  }
}
void KNetmapNmapPrefs::init()
{
  profileList->header()->hide();
  decList->header()->hide();
  decList->setSortColumn(-1);
  genPath->setCaption("Nmap Binary");
}
void KNetmapNmapPrefs::decList_selectionChanged( QListViewItem *i )
{
  if (i)
  {
    decDel->setEnabled(true);
    decUp->setEnabled(i != decList->firstChild());
    decDown->setEnabled(i != decList->lastChild());
    decEntry->setText(i->text(0));
  }
  else
  {
    decDel->setEnabled(false);
    decUp->setEnabled(false);
    decDown->setEnabled(false);
    decEntry->setText(QString::null);
  }
}
void KNetmapNmapPrefs::profileList_selectionChanged( QListViewItem *i )
{
  if (i)
  {
    delProfile->setEnabled(true);
    defProfile->setEnabled(true);
    profProperties->setEnabled(true);
    scan->setEnabled(true);
    disc->setEnabled(true);
    tim->setEnabled(true);
    misc->setEnabled(true);
    profEntry->setEnabled(true);
    profEntry->setText(i->text(0));
    cliEntry->setEnabled(true);
  }
  else
  {
    delProfile->setEnabled(false);
    defProfile->setEnabled(false);
    profProperties->setEnabled(false);
    profEntry->setEnabled(false);
    profEntry->setText(QString::null);
    cliEntry->setEnabled(false);
  }
}
void KNetmapNmapPrefs::decUp_clicked()
{
  QListViewItem *i = decList->selectedItem();
  i->itemAbove()->moveItem(i);
  emit decoysModified();
}
void KNetmapNmapPrefs::decDown_clicked()
{
  QListViewItem *i = decList->selectedItem();
  i->moveItem(i->itemBelow());
  emit decoysModified();
}
void KNetmapNmapPrefs::decDel_clicked()
{
  delete decList->selectedItem();
  decList_selectionChanged(decList->selectedItem());
  emit decoysModified();
}
void KNetmapNmapPrefs::decNew_clicked()
{
  if (decEntry->text().isEmpty())
    {
      KListViewItem *i = new KListViewItem(decList, "a.b.c.d");
      decList->setSelected(i, true);
      decList->setCurrentItem(i);
      decEntry->setFocus();
      decEntry->selectAll();
    }
  else
    {
      (void) new KListViewItem(decList, decEntry->text());
      decList->clearSelection();
      decEntry->setText(QString::null);
    }
  emit decoysModified();
}

void KNetmapNmapPrefs::decEntry_textChanged( const QString &s )
{
  QListViewItem *i = decList->selectedItem();
  if (i) i->setText(0, s);
}

void KNetmapNmapPrefs::decEntry_returnPressed()
{
  decList->clearSelection();
}
QStringList KNetmapNmapPrefs::decoyList()
{
  QStringList items;
  QListViewItem *i = decList->firstChild();
  if (i)
    {
      items.append(i->text(0));
      while ((i = i->nextSibling()) != 0)
	{
	  items.append(i->text(0));
	}
    }
  return items;
}
void KNetmapNmapPrefs::setDecoyList( const QStringList &l )
{
  decList->clear();
  for (QStringList::ConstIterator it=--l.end(); it!=l.begin(); --it)
    {
      (void) new KListViewItem(decList, *it);
    }
  (void) new KListViewItem(decList, *(l.begin()));
}
void KNetmapNmapPrefs::sourceIfaceCheck_toggled( bool b )
{
  sourceIfaceValue->setEnabled(b);
}
void KNetmapNmapPrefs::sourceIPCheck_toggled( bool b )
{
  sourceIPValue->setEnabled(b);
}
void KNetmapNmapPrefs::sourcePortCheck_toggled( bool b )
{
  sourcePortValue->setEnabled(b);
}

void KNetmapNmapPrefs::tcpScanCombo_activated( int i )
{
  scanIdentd->setEnabled(i == ScanConnect);
  if (i == ScanIdle)
    {
      scanTypeLabel->setEnabled(true);
      scanTypeEntry->setEnabled(true);
    }
  else
    {
      scanTypeLabel->setEnabled(false);
      scanTypeEntry->setEnabled(false);
    }
}
