/* KNetmap - KDE Network Mapper
 *
 * Copyright (C) 2003 Joshua T. Corbin <jcorbin@linuxmail.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef KNETMAPNMAPPROFILE_H
#define KNETMAPNMAPPROFILE_H

#include "knetmapnmapparser.h"

#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>

class KNetmapNmapScanner;

class KNetmapNmapProfile : public QObject
{
  Q_OBJECT
 public:
  KNetmapNmapProfile(KNetmapNmapScanner *, const char *);
  KNetmapNmapProfile(KNetmapNmapScanner *, const char *, const QString &);
  ~KNetmapNmapProfile();
  int scanStageCount() const;
  enum scanMode {
    subnetScan=1,
    hostScan
  };

  int timParMin() const;
  int timParMax() const;
  int timRttMin() const;
  int timRttMax() const;
  int timRttInit() const;
  int timTTL() const;
  int timHTime() const;
  int timDelay() const;
  int datalen() const;
  int maxSockets() const;
  int ports() const;
  int flags() const;
  int ping() const;
  int scan() const;
  int timing() const;
  const QString &zombie() const;
  QStringList portsList();

  QString TCPPingPortsString();
  QString SYNPingPortsString();
  QString UDPPingPortsString();

  QStringList cmdline(int=hostScan, bool=false);
//   void saveConfig(KConfig *);
//   void readConfig(KConfig *);
  bool isDefault() const;
  void setDefault(bool def=true);
  bool canPing() const {return (m_pingt & NoPing) ? false : true;};
  bool needRoot();

  enum scanType {
    PingScan=0x0001,    // -sP
    SYNScan=0x0002,     // -sS
    ACKScan=0x0004,     // -sA
    TCPScan=0x0008,     // -sT
    FINScan=0x0010,     // -sF
    XMasScan=0x0020,    // -sX
    NullScan=0x0040,    // -sN
    UDPScan=0x0080,     // -sU
    WindowScan=0x0100,  // -sW
    IdleScan=0x0200,    // -sI
    VersionScan=0x0400, // -sV
    RPCScan=0x0800,     // -sR
    FINACKScan=0x1000,  // -sM
    MethodMask=SYNScan|ACKScan|TCPScan|FINScan|XMasScan|NullScan|UDPScan|WindowScan|IdleScan
  };

  enum pingType {
    NoPing=0x01,       // -P0
    TCPPing=0x02,      // -PT
    SYNPing=0x04,      // -PS
    UDPPing=0x08,      // -PU
    ICMPEchoPing=0x10, // -PE
    ICMPTSPing=0x20,   // -PP
    ICMPMaskPing=0x40,  // -PM
    DefaultPing=ICMPEchoPing|TCPPing
  };

  enum scanPorts {
    portsDefault, // Nothing
    portsAll,     // -p-
    portsFast,    // -F
    portsRange    // -p ...
  };

  enum e_flags {
    OS=0x0001,                // -O
    AggressiveMode=0x0002,    // -A
    Ident=0x0004,             // -I
    Fragment=0x0008,          // -f
    NoDNS=0x0010,             // -n
    AlwaysDNS=0x0020,         // -R
    OrderedPorts=0x0040,      // -r
    RandomizeHosts=0x0080,    // --randomize_hosts
    OSLimit=0x0100,           // --osscan_limit
    OSGuess=0x0200            // --osscan_guess
  };

  enum timingPreset {
    Paranoid=0, // -T0
    Sneaky,     // -T1
    Polite,     // -T2
    Normal,     // -T3
    Aggressive, // -T4
    Insane      // -T5
  };

 signals:
  void modified();

 public slots:
  void setFromCLI(const QString &, QStringList * =0);
  void setTimParMin(int);
  void setTimParMax(int);
  void setTimRttMin(int);
  void setTimRttMax(int);
  void setTimRttInit(int);
  void setTimTTL(int);
  void setTimHTime(int);
  void setTimDelay(int);
  void setDatalen(int);
  void setMaxSockets(int);
  void setPorts(int);
  void setFlags(int);
  void addFlag(int);
  void remFlag(int);
  void setPing(int);
  void addPing(int);
  void remPing(int);
  void setScan(int);
  void addScan(int);
  void remScan(int);
  void setTiming(int);
  void setZombie(const QString &);
  void setTCPPingPorts(const QString &);
  void setSYNPingPorts(const QString &);
  void setUDPPingPorts(const QString &);
  void setPortList(const QString &);

 private:
  bool m_default;           // Default or not

  // Command line opts
  int m_pingt;
  int m_scant;
  int m_flags;
  QValueList<int> m_tpport; // -PT<...>
  QValueList<int> m_spport; // -PS<...>
  QValueList<int> m_upport; // -PU<...>

  scanPorts       m_ports;
  QStringList     m_portslist;
  QString         m_zombie; // -sI <z>

  int m_dlen;               // --data_length <...>
  int m_ttl;                // --ttl <...>
  int m_nsox;               // -M <...>

  // Timing
  timingPreset m_timing; // -T<...>
  int m_htimeout;        // --host_timeout <...>
  int m_max_rtt;         // --max_rtt_timeout <...>
  int m_min_rtt;         // --min_rtt_timeout <...>
  int m_init_rtt;        // --initial_rtt_timeout <...>
  int m_scan_delay;      // --scan_delay <...>
  int m_max_par;         // --max_parallelism <...>
  int m_min_par;         // --min_parallelism <...>
};

#endif // KNETMAPNMAPPROFILE_H
