/* KNetmap - KDE Network Mapper
 *
 * Copyright (C) 2003 Joshua T. Corbin <jcorbin@linuxmail.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef KNETMAPNMAPSCANNER_H
#define KNETMAPNMAPSCANNER_H

#include <ktempfile.h>
#include <kprocio.h>
#include <klistview.h>
#include <ktextedit.h>
#include <kprogress.h>
#include <kpushbutton.h>

#include "knetmapscanner.h"

#ifndef MAKE_NMAP_VERSION
#define MAKE_NMAP_VERSION(a, b, c) (((a) << 16) | ((b) << 8) | (c))
#endif // MAKE_NMAP_VERSION

class KNetmapNmapScan;
class KNetmapNmapProfile;
class KNetmapNmapParser;
class KNetmapNmapConsole;
class KNetmapHost;
class KNetmapSubnet;
class KNetmapApp;

class KNetmapNmapScanner : public KNetmapScanner
{
  Q_OBJECT
public:
  KNetmapNmapScanner(KNetmapApp *app);
  ~KNetmapNmapScanner();
  virtual void prefPage(KNetmapPreferences *);
  KNetmapNmapProfile *profile(const QString &name=QString::null);
  QStringList profiles();
  KNetmapNmapParser *parser();
  enum scanMode {
    separateScans=0,
    groupedScan
  };

  bool needRoot();
  KNetmapApp *getApp() const {return (KNetmapApp *)parent();};

  bool probeExecutable();
  bool nmapIsVersion(int maj, int min, int subver=0) const;
  bool nmapIsVersion(const QString &) const;
  const QStringList cmdline() const;

  bool isSuid() const;
  const QString executable() const;
  const QString version() const;
  const QString datadir() const;
  const QString sourceIP() const;
  const QString sourceIface() const;
  const QString sourcePort() const;
  const QStringList decoys() const;
  bool autostart() const;
  bool closedone() const;
  bool useDecoys() const;
  int scanmode() const;

public slots:
  void setFromCLI(const QString &, QStringList * =0); 
  void setScanmode(int);
  void setExecutable(const QString &);
  void setDatadir(const QString &);
  void setSourceIP(const QString &);
  void setSourceIface(const QString &);
  void setSourcePort(const QString &);
  void setAutostart(bool);
  void setClosedone(bool);
  void setUseDecoys(bool);
  void setDecoys(const QStringList &);
  void import();
  void replugProfiles();
  void parserDone();
  void parserFailed();
  virtual void initActions();
  virtual void readConfig(KConfig *);
  virtual void saveConfig(KConfig *);
  virtual void plugScanMenu(QPtrList<KAction> *);

signals:
  void versionChanged(const QString &);

protected slots:
  void internalScanSlot();
  void scanWidgetItemActivated();

private slots:
  void processExited(KProcess *);
  void gotOutput(KProcIO *);

private:
  void getExecVersion();
  QString m_executable;
  QString m_datadir;
  QString m_version;
  int m_ver;
  bool m_suid;
  KProcIO *m_proc;

  int m_scanmode;
  QStringList m_decoys;
  QString m_ip;
  QString m_port;
  QString m_iface;
  bool b_decoys;
  bool b_autostart;
  bool b_closedone;
};

class KNetmapNmapScan : public KNetmapScan
{
  Q_OBJECT
public:
  enum parserStatus {
    parseNone,
    parseRunning,
    parseDone,
    parseFailed
  };

  KNetmapNmapScan(KNetmapNmapScanner *, KNetmapNmapProfile *, const QString &, scanMode=hostScan);
  KNetmapNmapScan(KNetmapNmapScanner *, KNetmapNmapProfile *, const QStringList &, scanMode=hostScan);
  ~KNetmapNmapScan();
  KNetmapNmapScanner *scanner() const;
  KNetmapApp *getApp() const;
  QString xmlFile() const;
  QString nmapOutput();

protected:
  void handleNmapLine(const QString &);

public slots:
  virtual void start();
  virtual void stop();
  void procExitSlot(KProcess *);
  void gotOutput(KProcIO *);
  void killerExit(KProcess *);

protected slots:
  void parserDone();
  void parserFailed();

signals:
  void textChanged(const QString &); 

private:
  KNetmapNmapProfile *m_profile;
  KNetmapNmapConsole *m_console;
  KTempFile          *m_tmpfile;
  KProcIO            *m_proc;
  QString m_xmlFile;
  parserStatus parseStatus;
  KNetmapNmapParser *parser;

  bool gotOS;
  bool osFPR;
  bool sigged;
  bool m_asroot;
  int m_perstage;
  QString fingerprint;
  QString hostip;
  QStringList m_text;
};

class KNetmapNmapConsole : public KNetmapConsolePage
{
  Q_OBJECT
public:
  KNetmapNmapConsole(KNetmapConsole *, KNetmapNmapScan *);
  virtual ~KNetmapNmapConsole();

  enum iconType {
    errorIcon=1,
    infoIcon,
    hostIcon,
    subnetIcon,
    portIcon,
    scanIcon,
    timeIcon,
    doneIcon
  };

  KProgress *progress() const;
  KListView *listView() const;
  void append(const iconType, const QString &, const int=0);

public slots:
  void scanStarted();
  void scanFailed();
  void scanDone();
  void butt_clicked();
  void showStdout(bool);

protected:
  void append(const QString &, const QString &, const int=0);

private:
  KNetmapNmapScan *m_scan;
  KListView *m_list;
  KTextEdit *m_text;
  KProgress *m_prgs;
  KListViewItem *last;
  KPushButton *m_butt;
  int m_buttstate;
};

#endif // KNETMAPNMAPSCANNER_H
