/* KNetmap - KDE Network Mapper
 *
 * Copyright (C) 2003 Joshua T. Corbin <jcorbin@linuxmail.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <qlayout.h>
#include <qlabel.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <qvbox.h>

#include <klocale.h>

#include "knetmap.h"
#include "knetmappref.h"

KNetmapPreferences::KNetmapPreferences(KNetmapApp *parent)
    : KDialogBase(IconList, "KNetmap Preferences",
                  Help|Close, Close,
		  parent, "prefs", true)
{
}

KNetmapApp *KNetmapPreferences::getApp() const
{
  return (KNetmapApp *)parent();
}

QVBox *KNetmapPreferences::vboxPage(const QString &title,
				    const QString &header,
				    const QString &icon)
{
  return addVBoxPage(title, header,
		     KGlobal::iconLoader()->loadIcon
		     (icon, KIcon::NoGroup, KIcon::SizeLarge));
}

#include "knetmappref.moc"
