/* KNetmap - KDE Network Mapper
 *
 * Copyright (C) 2003 Joshua T. Corbin <jcorbin@linuxmail.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef KNETMAPSCANNER_H
#define KNETMAPSCANNER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 
#include <qobject.h>
#include <kaction.h>
#include <klocale.h>
#include <kconfig.h>

#include "knetmapconsole.h"
#include "knetmappref.h"

class KNetmapApp;
class KNetmapScan;

class KNetmapScanner : public QObject
{
  Q_OBJECT
public:
  KNetmapScanner(KNetmapApp *app, const char *name=0);
  virtual ~KNetmapScanner();
  virtual QString icon() const {return m_icon;};
  virtual void prefPage(KNetmapPreferences *) {};
  virtual KNetmapApp *getApp() const {return (KNetmapApp *)parent();};

public slots:
  virtual void initActions() {};
  virtual void readConfig(KConfig *) {};
  virtual void saveConfig(KConfig *) {};
  virtual void plugScanMenu(QPtrList<KAction> *) {};

signals:
  void scanAdded(KNetmapScan *);

protected:
  QString m_icon;

private:
};

class KNetmapScan : public QObject
{
  Q_OBJECT
public:
  enum scanMode {
    subnetScan=1,
    hostScan
  };
  enum scanState {
    scanStopped=0,
    scanDone=1,
    scanRunning=2,
    scanPaused
  };

  KNetmapScan(KNetmapScanner *, const QStringList &, scanMode=hostScan);
  virtual ~KNetmapScan();
  virtual QString icon() const {return m_icon;};
  virtual QString title() const {return m_title;};
  virtual KNetmapConsolePage *consolePage() const {return con;};
  virtual const QStringList targets() const {return m_targets;};
  virtual scanMode getScanMode() const {return m_mode;};

public slots:
  virtual void start() {};
  virtual void stop() {};
  virtual void pause() {};
  virtual void resume() {};

signals:
  void started();
  void stopped();
  void paused();
  void resumed();
  void finished();
  void failed();

protected:
  scanState m_state;
  scanMode m_mode;
  QString m_icon, m_title;
  QStringList m_targets;
  KNetmapConsolePage *con;
};

#endif // KNETMAPSCANNER_H
