/* KNetmap - KDE Network Mapper
 *
 * Copyright (C) 2003 Joshua T. Corbin <jcorbin@linuxmail.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef KNETMAPSCANWIDGET_H
#define KNETMAPSCANWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qstring.h>
#include <qstringlist.h>
#include <qregexp.h>
#include <qwidget.h>
#include <qptrlist.h>
#include <ktoolbar.h>
#include <kaction.h>
#include <kcombobox.h>

class KNetmapApp;

class KNetmapScanWidget : public KToolBar
{
  Q_OBJECT
public:
  KNetmapScanWidget(KNetmapApp *);
  ~KNetmapScanWidget();
  KNetmapApp *getApp() const {return m_app;};
  const QString targetString(); // Returns target string
  QStringList targets();  // Expands wildcards and ranges in the target string into a list of IPs

public slots:
  void updateMenu();
  void readConfig(KConfig *);
  void saveConfig(KConfig *);
  void scanMenuActivated(int);
  void addTarget(const QString &);

protected slots:
  void updateDefault(const QString &text);
  void scan();

protected:
  void addTargetsToHistory();

private:
  QString m_default;
  KNetmapApp *m_app;
  KActionMenu *scanButton;
  KSelectAction *defaultScan;
  QPtrList<KAction> menuActions;
  QString m_tstr;
  KCompletion *comp;
  KComboBox *combo;
};

class TermCompletion : public KCompletion
{
  Q_OBJECT
public:
  TermCompletion();
  ~TermCompletion();

  virtual QString makeCompletion(const QString& string);
  // QStringList substringCompletion(const QString& string) const;
  // QString previousMatch();
  // QString nextMatch();
  // virtual const QString& lastMatch() const { return myLastMatch; }
protected:
  virtual void postProcessMatch(QString *match) const;
  virtual void postProcessMatches(QStringList * matches) const;
  virtual void postProcessMatches(KCompletionMatches * matches) const;
private:
  QString prefix;
};

#endif // KNETMAPSCANWIDGET_H
