/* KNetmap - KDE Network Mapper
 *
 * Copyright (C) 2003 Joshua T. Corbin <jcorbin@linuxmail.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <qobjectlist.h>

#include "knetmapsubnet.h"
#include "knetmapdoc.h"
#include "knetmaphost.h"

KNetmapSubnet::KNetmapSubnet(QString n)
  : QObject(0)
{
  m_ccount=0;
  if (m_ip.set(n))
    setName(m_ip.cidrstr());
}

KNetmapSubnet::KNetmapSubnet(KNetmapDoc *parent, QString n)
  : QObject(parent)
{
  m_ccount=0;
  if (m_ip.set(n))
    setName(m_ip.cidrstr());
}

KNetmapSubnet::KNetmapSubnet(KNetmapSubnet *parent, QString n)
  : QObject(parent)
{
  m_ccount=0;
  if (m_ip.set(n))
    setName(m_ip.cidrstr());
}

KNetmapSubnet::~KNetmapSubnet()
{
}

int KNetmapSubnet::compare(KNetmapSubnet *s,
			   bool)
{
  if (m_ip < s->m_ip)
    return -1;
  else if (m_ip == s->m_ip)
    return 0;
  else
    return 1;
}

void KNetmapSubnet::childEvent(QChildEvent *e)
{
  if (e->inserted())
    if (e->child()->inherits("KNetmapSubnet"))
      {
	KNetmapSubnet *sub = (KNetmapSubnet *)e->child();
	emit subnetAdded(sub);
	if (!m_ccount)
	  emit modified();
	else
	  --m_ccount;
	connect(sub, SIGNAL(modified()),
		this, SIGNAL(modified()));
	connect(sub, SIGNAL(destroyed()),
		this, SIGNAL(modified()));
      }
    else if (e->child()->inherits("KNetmapHost"))
      {
	KNetmapHost *host = (KNetmapHost *)e->child();
	emit hostAdded(host);
	if (!m_ccount)
	  emit modified();
	else
	  --m_ccount;
	connect(host, SIGNAL(modified()),
		this, SIGNAL(modified()));
	connect(host, SIGNAL(destroyed()),
		this, SIGNAL(modified()));

      }
}

IPv4 KNetmapSubnet::ip()
{
  return m_ip;
}

void KNetmapSubnet::serialize(QDomDocument doc, QDomElement parent)
{
  QDomElement me = doc.createElement("Subnet");
  me.setAttribute("cidrstr", m_ip.cidrstr());
  parent.appendChild(me);

  const QObjectList *l = children();
  if (!l || l->isEmpty()) return;

  QObjectListIt it(*l);
  QObject *o;
  while ((o=it.current()) != 0)
    {
      ++it;
      if (o->inherits("KNetmapSubnet"))
	((KNetmapSubnet *)o)->serialize(doc, me);
      else if (o->inherits("KNetmapHost"))
	((KNetmapHost *)o)->serialize(doc, me);
      else
	qWarning("Object is of class: %s", o->className());
    }
}

KNetmapSubnet::KNetmapSubnet(KNetmapDoc *parent, QDomElement me)
  : QObject(parent)
{
  m_ccount=0;
  if (m_ip.set(me.attribute("cidrstr")))
    {
      setName(m_ip.cidrstr());
      QDomNode n = me.firstChild();
      while (!n.isNull())
	{
	  if (n.nodeType() == QDomNode::ElementNode)
	    {
	      QDomElement e = n.toElement();
	      if (e.tagName() == "Subnet")
		{
		  KNetmapSubnet::deserialize(this, e);
		  m_ccount++;
		}
	      else if (e.tagName() == "Host")
		{
		  KNetmapHost::deserialize(this, e);
		  m_ccount++;
		}
	      else
		qWarning("Unknown element %s in subnet element", e.tagName().ascii());
	    }
	  n = n.nextSibling();
	}
    }
}

KNetmapSubnet::KNetmapSubnet(KNetmapSubnet *parent, QDomElement me)
  : QObject(parent)
{
  m_ccount=0;
  if (m_ip.set(me.attribute("cidrstr")))
    {
      setName(m_ip.cidrstr());
      QDomNode n = me.firstChild();
      while (!n.isNull())
	{
	  if (n.nodeType() == QDomNode::ElementNode)
	    {
	      QDomElement e = n.toElement();
	      if (e.tagName() == "Subnet")
		{
		  KNetmapSubnet::deserialize(this, e);
		  m_ccount++;
		}
	      else if (e.tagName() == "Host")
		{
		  KNetmapHost::deserialize(this, e);
		  m_ccount++;
		}
	      else
		qWarning("Unknown element %s in subnet element", e.tagName().ascii());
	    }
	  n = n.nextSibling();
	}
    }
}

void KNetmapSubnet::deserialize(KNetmapDoc *parent, QDomElement me)
{
  if (!me.hasAttribute("cidrstr"))
    {
      qWarning("Subnet element does not have a cidrstr attribute");
      return;
    }
  (void) new KNetmapSubnet(parent, me);
}

void KNetmapSubnet::deserialize(KNetmapSubnet *parent, QDomElement me)
{
  if (!me.hasAttribute("cidrstr"))
    {
      qWarning("Subnet element does not have a cidrstr attribute");
      return;
    }
  (void) new KNetmapSubnet(parent, me);
}

#include "knetmapsubnet.moc"
