/* KNetmap - KDE Network Mapper
 *
 * Copyright (C) 2003 Joshua T. Corbin <jcorbin@linuxmail.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef KNETMAPSUBNET_H
#define KNETMAPSUBNET_H

#include <qobject.h>
#include <qstring.h>
#include <qptrlist.h>
#include <qdom.h>

#include "ipv4.h"

#define SUBNET_ICON "net_switch"

class KNetmapDoc;
class KNetmapHost;

class KNetmapSubnet : public QObject
{
  Q_OBJECT
public:
  KNetmapSubnet(QString n);
  KNetmapSubnet(KNetmapDoc    *parent, QString n);
  KNetmapSubnet(KNetmapSubnet *parent, QString n);
  virtual ~KNetmapSubnet();
  IPv4 ip();

  void serialize(QDomDocument, QDomElement);
  static void deserialize(KNetmapDoc *,    QDomElement);
  static void deserialize(KNetmapSubnet *, QDomElement);
  virtual int compare(KNetmapSubnet *, bool);

signals:
  void subnetAdded(KNetmapSubnet *);
  void hostAdded(KNetmapHost *);
  void modified();

protected:
  virtual void childEvent(QChildEvent *);

private:
  KNetmapSubnet(KNetmapDoc *,    QDomElement);
  KNetmapSubnet(KNetmapSubnet *, QDomElement);
  IPv4 m_ip;
  int m_ccount;
};

#endif // KNETMAPSUBNET_H
