/* KNetmap - KDE Network Mapper
 *
 * Copyright (C) 2003 Joshua T. Corbin <jcorbin@linuxmail.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <qhbox.h>
#include <qgrid.h>
#include <qobjectlist.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>

#include "knetmapsubnetpage.h"
#include "knetmapsubnet.h"
#include "knetmapview.h" // For SUBNET_ICON
#include "knetmap.h"
#include "ipv4.h"

KNetmapSubnetPage::KNetmapSubnetPage(QWidget *parent, const char *name)
  : QWidget(parent, name)
{
  QVBoxLayout *top_layout = new QVBoxLayout(this, 3, -1, "layout");

  // The title row
  QHBox *row1 = new QHBox(this, "row1");
  QLabel *icon = new QLabel(row1, "icon"); // The Icon
  QLabel *m_lbl = new QLabel(row1, "label");
  row1->setStretchFactor(icon, 0);
  row1->setStretchFactor(m_lbl, 1);
  icon->setFixedWidth(52);
  icon->setPixmap(KGlobal::iconLoader()->loadIcon(SUBNET_ICON, KIcon::NoGroup, 48));

  // The grid
  QGrid *grid = new QGrid(2, this, "grid");
  QLabel *l_netw = new QLabel(i18n("Network Address:"), grid, "l_netw");
  QLabel *m_netw = new QLabel(grid, "netw");
  QLabel *l_brdc = new QLabel(i18n("Broadcast Address:"), grid, "l_brdc");
  QLabel *m_brdc = new QLabel(grid, "brdc");
  QLabel *l_mask = new QLabel(i18n("Netmask:"), grid, "l_mask");
  QLabel *m_mask = new QLabel(grid, "mask");
  QLabel *l_stat = new QLabel(i18n("Stats:"), grid, "l_stat");
  QLabel *m_stat = new QLabel(grid, "stat");

  grid->setSpacing(2);
  l_netw->setSizePolicy(QSizePolicy::Minimum, QSizePolicy::Minimum);
  l_brdc->setSizePolicy(QSizePolicy::Minimum, QSizePolicy::Minimum);
  l_mask->setSizePolicy(QSizePolicy::Minimum, QSizePolicy::Minimum);
  l_stat->setSizePolicy(QSizePolicy::Minimum, QSizePolicy::Minimum);
  m_netw->setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Minimum);
  m_brdc->setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Minimum);
  m_mask->setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Minimum);
  m_stat->setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Minimum);

  top_layout->addWidget(row1, 0);
  top_layout->addSpacing(3);
  top_layout->addWidget(grid, 0);
  top_layout->addStretch(1);

  connect(getApp()->getDocument(), SIGNAL(currentChanged(QObject *)),
	  this, SLOT(update(QObject *)));
}

KNetmapSubnetPage::~KNetmapSubnetPage()
{
}

KNetmapApp *KNetmapSubnetPage::getApp()
{
  return ((KNetmapView *)parent()->parent()->parent()->parent())->getApp();
}

void KNetmapSubnetPage::update(QObject *o)
{
  KNetmapSubnet *sub=0;
  if (o && o->inherits("KNetmapSubnet"))
    sub = (KNetmapSubnet *)o;

  m_sub = sub;

  if (m_sub)
    {
      ((QLabel *)child("label", "QLabel"))
	->setText(QString("%1 - %2")
		  .arg(i18n("Subnet"))
		  .arg(m_sub->ip().cidrstr()));

      ((QLabel *)child("netw", "QLabel"))
	->setText(m_sub->ip().network());

      ((QLabel *)child("brdc", "QLabel"))
	->setText(m_sub->ip().broadcast());

      ((QLabel *)child("mask", "QLabel"))
	->setText(m_sub->ip().netmask());

      QObjectList *hosts = m_sub->queryList("KNetmapHost");

      int space =m_sub->ip().useableCount();
      int hcnt = hosts->count();
      double pct = (((double)hcnt)/((double)space))*100.0;

      ((QLabel *)child("stat", "QLabel"))
	->setText(QString("%1/%2 hosts up (%3%)")
		  .arg(hcnt)
		  .arg(space)
		  .arg(pct, 0, 'f', 1));

      delete hosts;
    }
}
#include "knetmapsubnetpage.moc"
