/* KNetmap - KDE Network Mapper
 *
 * Copyright (C) 2003 Joshua T. Corbin <jcorbin@linuxmail.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef KNETMAPVIEW_H
#define KNETMAPVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 
#include <qwidget.h>
#include <klistview.h>
#include <qobject.h>
#include <qsplitter.h>
#include <qlayout.h>
#include <qwidgetstack.h>
#include <qguardedptr.h>

#include "knetmapdoc.h"

#define SUBNET_ICON "net_switch"

class KNetmapSubnet;
class KNetmapHost;
class KNetmapPort;
class KNetmapTree;
class KNetmapSubnetPage;
class KNetmapHostPage;
class KNetmapConsole;
class KNetmapApp;

class KNetmapView : public QWidget
{
  Q_OBJECT
 public:
  KNetmapView(QWidget *parent=0);
  ~KNetmapView();
  KNetmapDoc     *getDocument() const;
  KNetmapConsole *getConsole()  const;
  KNetmapApp *getApp() const;

 public slots:
  void updatePage(QObject *);
  void slotContextMenu(KListView *, QListViewItem *, const QPoint &);

 private:
  QVBoxLayout        *top_layout;
  KNetmapTree        *tree;	
  QSplitter          *hsplit;
  QSplitter          *vsplit;
  QWidgetStack       *main;
  QWidget            *bpage; // Blank page
  KNetmapSubnetPage  *spage; // Subnet info page
  KNetmapHostPage    *hpage; // Host info page
};

////////////////////////////////////////////////////////////
class KNetmapTree : public KListView
{
  Q_OBJECT
 public:
  KNetmapTree(QWidget *parent);
  virtual ~KNetmapTree();
  KNetmapView *getView() const;

  enum itemRTTI
    {
      subnetRTTI = 2001,
      hostRTTI   = 2002
    };

 public slots:
  void insertSubnet(KNetmapSubnet *);
  void removeSubnet(KNetmapSubnet *);

 protected slots:
  void selectionChangedSlot();
  void currentChangedSlot(QListViewItem *);

 private:
  QPtrList<KNetmapHost> m_selHosts;
  QPtrList<KNetmapSubnet> m_selSubs;
};

////////////////////////////////////////////////////////////
class KNetmapSubnetTreeItem : public QObject, public KListViewItem
{
  Q_OBJECT
 public:
  KNetmapSubnetTreeItem(KNetmapTree           *parent, KNetmapSubnet *sub);
  KNetmapSubnetTreeItem(KNetmapSubnetTreeItem *parent, KNetmapSubnet *sub);
  virtual ~KNetmapSubnetTreeItem();
  KNetmapSubnet *subnet() const {return (KNetmapSubnet *)m_sub;};
  virtual int rtti() const {return KNetmapTree::subnetRTTI;};
  virtual int compare(QListViewItem *, int, bool) const;

 public slots:
  void insertSubnet(KNetmapSubnet *);
  void insertHost(KNetmapHost *);

 private:
  QGuardedPtr<KNetmapSubnet> m_sub;
};

////////////////////////////////////////////////////////////
class KNetmapHostTreeItem : public QObject, public KListViewItem
{
  Q_OBJECT
 public:
  KNetmapHostTreeItem(KNetmapSubnetTreeItem *parent, KNetmapHost *host);
  virtual ~KNetmapHostTreeItem();
  KNetmapHost *host() const {return (KNetmapHost *) m_host;};
  virtual int rtti() const {return KNetmapTree::hostRTTI;};
  virtual int compare(QListViewItem *, int, bool) const;

 public slots:
  void setIcon(const QString &);
  void setName(const QString &);

 private:
  QGuardedPtr<KNetmapHost> m_host;
};

#endif // KNETMAPVIEW_H

