/* KNetmap - KDE Network Mapper
 *
 * Copyright (C) 2003 Joshua T. Corbin <jcorbin@linuxmail.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "knetmap.h"

static const char *description =
  I18N_NOOP("KNetmap - A KDE Network Mapper.");
	
static KCmdLineOptions options[] =
  {
    { "+[File]", I18N_NOOP("file to open"), 0 },
    { 0, 0, 0 }
  };

int main(int argc, char *argv[])
{
  KAboutData aboutData("knetmap", I18N_NOOP("KNetmap"),
		       VERSION, description, KAboutData::License_GPL,
		       "(c) 2003-2004, Joshua T. Corbin",
		       0,
		       "http://knetmap.sourceforge.net/",
		       "jcorbin@linuxmail.org");
  aboutData.addAuthor("Joshua T. Corbin", 0, "jcorbin@linuxmail.org");
  aboutData.addCredit("Fyodor", 0, "fyodor@insecure.org", "http://www.insecure.org/");

  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication app;
 
  if (app.isRestored())
    {
      RESTORE(KNetmapApp);
    }
  else 
    {
      KNetmapApp *knetmap = new KNetmapApp();
      knetmap->show();

      KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		
      if (args->count())
	knetmap->openDocumentFile(args->arg(0));
      else
	knetmap->openDocumentFile();
      args->clear();
    }

  return app.exec();
}  
