/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CISCOCERTIFICATEENROLLMENT_H
#define CISCOCERTIFICATEENROLLMENT_H

#include <kdialogbase.h>
#include "ciscocertificateenrollmentbase.h"
#include "ciscocertificateenrollmentfinishwidgetbase.h"
#include "ciscocertificateenrollmentdatadialog.h"
#include <qprocess.h>
#include <qstring.h>
#include <qstringlist.h>
#include <kdialogbase.h>
#include <kprogress.h>
#include <qwizard.h>
#include <qtimer.h>
#include "kvpncconfig.h"

/**
	@author Christoph Thielecke <crissi99@gmx.de>
*/
class CiscoCertificateEnrollment : public QWizard
{
	Q_OBJECT
	public:
		CiscoCertificateEnrollment ( QWidget *parent, const char* caption, KVpncConfig *GlobalConfig );
		~CiscoCertificateEnrollment();
		QProcess *EnrollmentProcess;
		QProcess *DeleteProcess;
		KVpncConfig *GlobalConfig;
		bool done;
		bool finished;
		bool valuesOk;
		QStringList *env;


	public slots:
		void accept();
		void canAccept();
		void enrollmentToggled(bool);
		void setupPages();
		void showPage( QWidget* page );
		void next ();
		void back();
		void reject();
		void readFromStdout();
		void readFromStderr();
		void readFromStdout_cancel();
		void readFromStderr_cancel();
		void checkProgress();
		void enrollmentProcessFinished();
		void cancelProcessFinished();


	public:
		CiscoCertificateEnrollmentBase *selectionpage;
		CiscoCertificateEnrollmentDataDialogBase *datapage;
		CiscoCertificateEnrollmentFinishWidgetBase *finishpage;
		QWidget* currentpage; // pointer to current page
		QWidget* previouspage; //< pointer to previous page
		KProgressDialog *ProgressDlg;

	public:
		QString type;
		QString successmsg;
		int success;
		QString CA;
		QString CaUrl;
		QString ChallengePassword;
		QString CaDomain;
		QString FileEncoding;
		QString FilenameURL;
		QString Ip;
		QString State;
		QString Department;
		QString Company;
		QString Domain;
		QString Name;
		QString Email;
		QString Country;

	private:
		QTimer CheckEnrollmentTimer;

};

#endif
