/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef __KVPNCKICKER_H__
#define __KVPNCKICKER_H__

#include <qpixmap.h>
#include <qwidget.h>
#include <ksystemtray.h>
#include <kpopupmenu.h>
#include "kvpncconfig.h"

class KVpncKicker : public KSystemTray {
	Q_OBJECT


public:
	KVpncKicker( KVpncConfig *GlobalConfig,QWidget*parent = 0, const char *name = 0 );
	~KVpncKicker();
	KPopupMenu* menu();
	enum status {disconnected=0, connecting=1, connected=2};
	void setStatus( int status );

	void closeEvent( QCloseEvent* e );
protected:
	void initDockWindow();
	QWidget *parent;
	KVpncConfig *GlobalConfig;

private:
	// color
	QColor currentStatus;
	// icons
	QPixmap connectedIcon;
	QPixmap disconnectedIcon;
	QPixmap connectingIcon;
signals:
        void closeEventKicker(QCloseEvent *e);

};

#endif
