/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KENCRYPTIONGROUP_H
#define KENCRYPTIONGROUP_H

using namespace std;

#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <kcombobox.h>
#include <qtoolbutton.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <qregexp.h>
#include <kmessagebox.h>
#include <qhbox.h>
#include <qvgroupbox.h>

#include "wcard.h"

#include "kwcentry.h"
#include "kwavecontrol.h"
#include "kkeydialog.h"

/**
	@author Matthias Reif <matthias.reif@informatik.tu-chemnitz.de>
 */
class KEncryptionGroup : public QVGroupBox
{
Q_OBJECT
public:
	KEncryptionGroup( QString title, QWidget *parent = 0, const char *name = 0 );

	~KEncryptionGroup();
	void setCurrentKey( Encoding encoding );
	void setKeys( vector< EKey > keys );
	void showError( QString error );
	void hideError();
	int getMode();
	static unsigned char* hexToKey( QString hex, int& length );
	QString getCurrentKey();
	int getCurrentIndex();

private:
	QRadioButton* offRadio;
	QRadioButton* openRadio;
	QRadioButton* restrictedRadio;

	QLabel* keyLabel;
	KComboBox* keySelection;
	QToolButton *editButton;

	QLabel* errorLabel;

protected slots:
	void offToggled( bool on );
	void editSlot();
	void keyActivated( int index );
	void modeChangedSlot( int );
signals:
	void changed( int index, unsigned char* key, int length );
	void changed( int index );
	void modeChanged( int mode );
};

#endif
