/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KPOWERGROUP_H
#define KPOWERGROUP_H

using namespace std;
#include <vector>

#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <kcombobox.h>
#include <qhbox.h>
#include <qvgroupbox.h>


#include "kwcentry.h"
#include "wcard.h"
#include "kwavecontrol.h"

/**
@author Matthias Reif
*/
class KPowerGroup : public QVGroupBox
{
Q_OBJECT
public:
	KPowerGroup( QString title, QWidget *parent = 0, const char *name = 0 );
	~KPowerGroup();
	
	void insertPowers( WCard* card );
	void setPower( bool enabled, int flags );

protected:
	QRadioButton* enableRadio;
	QRadioButton* disableRadio;

	KComboBox* modeSelection;
	vector< int > modes;

protected slots:
	void changedSlot( int index = -1 );
signals:
	void changed( bool enabled, int mode );

};

#endif
