/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KPROFILEWIDGET_H
#define KPROFILEWIDGET_H

#include <qwidget.h>
#include <kpushbutton.h>
#include <klistview.h>
#include <qheader.h>
#include <qlabel.h>
#include <qstringlist.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qlayout.h>


#include <kiconloader.h>
#include <kinputdialog.h>
#include "kwavecontrol.h"

#include "wcardlib.h"

class WWidget;

class Profile
{
public:
	QString essid;
	double frequency;
	QString ip;
	QString gateway;
	int mode;
	int security;
	QString key;
	int keyIndex;
	bool dhcp;
	
	enum ORDER{ ESSID, IP, MODE, FREQUENCY, GATEWAY, SECURITY, KEY, KEY_INDEX, DHCP, MAX };
	
// 	static const int ESSID = 0;
// 	static const int IP = 1;
// 	static const int MODE = 2;
// 	static const int FREQUENCY = 3;
// 	static const int GATEWAY = 4;
// 	static const int SECURITY = 5;
// 	static const int KEY = 6;
// 	static const int KEY_INDEX = 7;
// 	static const int DHCP = 8;
// 	static const int MAX = 8;
};

/**
@author Matthias Reif
*/
class KProfileWidget : public QWidget
{
Q_OBJECT
public:
	KProfileWidget( WWidget* wWidget, QWidget *parent = 0, const char *name = 0 );
	~KProfileWidget();
	void restoreProfiles();
    void test();
protected:
	KListView* listView;
	KPushButton* loadButton;
	KPushButton* saveButton;
	KPushButton* removeButton;
	WWidget* wWidget;
	KConfig* config;
	QVBox* buttonBox;

	int essidCol, ipCol, gatewayCol, nameCol, dhcpCol, keyCol, modeCol, channelCol, encCol;

protected slots:
	void loadSlot();
	void saveSlot();
	void removeSlot();
	void selectionChangedSlot();
protected:
    void resizeEvent ( QResizeEvent * );
};

#endif
