/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kscaninformwidget.h"

KScanInformWidget::KScanInformWidget(QWidget *parent, const char *name) : QWidget(parent, name)
{
	vBox = new QVBox( this );
	title = new QLabel( "New networks found:", vBox );
}


KScanInformWidget::~KScanInformWidget()
{
}


/*!
    \fn KScanInformWidget::addCells( QMap< QString, KnownCell > newCells )
 */
void KScanInformWidget::addCells( QMap< QString, KnownCell > newCells )
{
	if( newCells.size() > 1 )
	{
		title->setText( "<u>New networks found:</u>" );
	}
	else
	{
		title->setText( "<u>New network found:</u>" );
	}
	title->adjustSize();
	QMap< QString, KnownCell >::iterator cell;
	for( cell = newCells.begin(); cell != newCells.end(); cell++ )
	{
		QLabel* l = new QLabel( cell.data().getEssid(), vBox );
		l->adjustSize();
	}
	
	vBox->adjustSize();
	this->adjustSize();
}


#include "kscaninformwidget.moc"
