/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kscanoptionswidget.h"

KScanOptionsWidget::KScanOptionsWidget(QWidget *parent, const char *name) : KDialogBase( parent, name, true, "Scan Options", Ok|Apply|Cancel, Ok, true )
{
	this->makeVBoxMainWidget();

	QVGroupBox* autoScanBox = new QVGroupBox( "Auto Scan", mainWidget() );
	startScanCheckBox = new QCheckBox( i18n( "scan on start" ), autoScanBox );
	QHBox* box2 = new QHBox( autoScanBox );
	autoScanCheckBox = new QCheckBox( i18n( "scan automaticly every" ), box2 );
	intervalSpinBox = new KIntSpinBox( 1, 999, 1, 60, 10, box2 );
	intervalSpinBox->setSuffix( " sec" );

	informCheckBox = new QCheckBox( i18n( "inform me immediately about new cells" ), autoScanBox );

	QHBox* box3 = new QHBox( autoScanBox );
	rememberCheckBox = new QCheckBox( i18n( "don't inform me about cells\nfound during the last" ), box3 );
	rememberSpinBox = new KIntSpinBox( 1, 999, 1, 10, 10, box3 );
	rememberSpinBox->setSuffix( " min" );

	connect( autoScanCheckBox, SIGNAL( clicked() ), this, SLOT( autoScanChanged() ) );
	connect( informCheckBox, SIGNAL( clicked() ), this, SLOT( autoScanChanged() ) );
	connect( rememberCheckBox, SIGNAL( clicked() ), this, SLOT( autoScanChanged() ) );
}


KScanOptionsWidget::~KScanOptionsWidget()
{
}


/*!
    \fn KScanOptionsWidget::autoScanChanged()
 */
void KScanOptionsWidget::autoScanChanged()
{
	intervalSpinBox->setEnabled( autoScanCheckBox->isChecked() );
	informCheckBox->setEnabled( autoScanCheckBox->isChecked() );
	rememberCheckBox->setEnabled( informCheckBox->isChecked() && autoScanCheckBox->isChecked() );
	rememberSpinBox->setEnabled( rememberCheckBox->isChecked() && rememberCheckBox->isEnabled() );
}


/*!
    \fn KScanOptionsWidget::getScanOptions()
 */
ScanOptions KScanOptionsWidget::getScanOptions()
{
	ScanOptions scanOptions;
	scanOptions.startScan = startScanCheckBox->isChecked();
	scanOptions.autoScan = autoScanCheckBox->isChecked();
	scanOptions.interval = intervalSpinBox->value();
	scanOptions.inform = informCheckBox->isChecked();
	scanOptions.remember = rememberCheckBox->isChecked();
	scanOptions.rememberTime = rememberSpinBox->value();
	return scanOptions;
}


/*!
    \fn KScanOptionsWidget::setScanOptions( ScanOptions scanOptions )
 */
void KScanOptionsWidget::setScanOptions( ScanOptions scanOptions )
{
	startScanCheckBox->setChecked( scanOptions.startScan );
	autoScanCheckBox->setChecked( scanOptions.autoScan );
	intervalSpinBox->setValue( scanOptions.interval );
	informCheckBox->setChecked( scanOptions.inform );
	rememberCheckBox->setChecked( scanOptions.remember );
	rememberSpinBox->setValue( scanOptions.rememberTime );
	autoScanChanged();
}


#include "kscanoptionswidget.moc"
