/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KSCANOPTIONSWIDGET_H
#define KSCANOPTIONSWIDGET_H

#include <kdialogbase.h>
#include <qlabel.h>
#include <knuminput.h>
#include <qcheckbox.h>
#include <qvgroupbox.h>
#include <qhbox.h>

#include "kwavecontrol.h"
#include "wcardlib.h"

/**
	@author Matthias Reif <matthias.reif@informatik.tu-chemnitz.de>
*/
class KScanOptionsWidget : public KDialogBase
{
Q_OBJECT
public:
	KScanOptionsWidget( QWidget *parent = 0, const char *name = 0 );
	~KScanOptionsWidget();
	ScanOptions getScanOptions();
	void setScanOptions( ScanOptions scanOptions );

private:
	QCheckBox* startScanCheckBox;

	QCheckBox* autoScanCheckBox;
	KIntSpinBox* intervalSpinBox;

	QCheckBox* informCheckBox;

	QCheckBox* rememberCheckBox;
	KIntSpinBox* rememberSpinBox;

public slots:
    void autoScanChanged();
};

#endif
