/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kthresholdgroup.h"

KThresholdGroup::KThresholdGroup( QString title, QWidget *parent, const char *name) : QHGroupBox( title, parent, name )
{
	this->setInsideSpacing( 10 );
	enableBox = new QCheckBox( i18n( "enabled" ), this );
	thresholdSpin = new KIntSpinBox( 1, 9999, 1, 1500, 10, this );     // 1500 byte = maximum packet size
	thresholdSpin->setSuffix( " Byte" );
	
	applyButton = new QToolButton( this );
	applyButton->setTextLabel( i18n( "apply" ), true );
	applyButton->setIconSet( QIconSet( KGlobal::iconLoader()->loadIcon( "ok", KIcon::Small ) ) );

	connect( enableBox, SIGNAL( toggled( bool ) ), thresholdSpin, SLOT( setEnabled( bool ) ) );
	connect( applyButton, SIGNAL( clicked( ) ), this, SLOT( applySlot() ) );
	connect( enableBox, SIGNAL( clicked( ) ), this, SLOT( enableClickedSlot() ) );
	
	changed = false;
	thresholdSpin->setEnabled( false );
}


KThresholdGroup::~KThresholdGroup()
{
}


/*!
    \fn KThresholdGroup::set( bool enabled, int value )
 */
void KThresholdGroup::set( bool enabled, int value )
{
	enableBox->setChecked( enabled );
	if( enabled )
	{
		thresholdSpin->setValue( value );
	}
}


/*!
    \fn KThresholdGroup::hasFocus()
 */
bool KThresholdGroup::hasFocus()
{
	return thresholdSpin->hasFocus();
}


/*!
    \fn KThresholdGroup::applySlot()
 */
void KThresholdGroup::applySlot()
{
	applied( enableBox->isChecked(), thresholdSpin->value() );
	changed = false;
}


#include "kthresholdgroup.moc"


/*!
    \fn KThresholdGroup::clearFocus()
 */
void KThresholdGroup::clearFocus()
{
	thresholdSpin->clearFocus();
}


/*!
    \fn KThresholdGroup::enableClickedSlot()
 */
void KThresholdGroup::enableClickedSlot()
{
	changed = true;
}


/*!
    \fn KThresholdGroup::hasChanged()
 */
bool KThresholdGroup::hasChanged()
{
	return changed;
}


/*!
    \fn KThresholdGroup::clearChanged()
 */
void KThresholdGroup::clearChanged()
{
	changed = false;
}
