/***************************************************************************
                          ktray.h  -  description
                             -------------------
    begin                : Die Nov 12 2002
    copyright            : (C) 2002 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTRAY_H
#define KTRAY_H

#include <qpixmap.h>
#include <qaction.h>
#include <qtimer.h>
#include <qtooltip.h>
#include <qstring.h>

#include <ksystemtray.h>
#include <kpopupmenu.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kiconloader.h>

#include "wwidget.h"
#include "smallwidget.h"
#include "kwavecontrol.h"
#include "wcardlib.h"
#include "wcard.h"

#include "ktraywidget.h"
#include "kscaninformwidget.h"

/**
	the tray icon with popup menu
	@author Matthias Reif
*/
class KTray :  public KSystemTray  {
  Q_OBJECT
public: 
	KTray( QString cmd, QWidget* parent = 0, const char *name = 0 );
	~KTray();

private:
	QPixmap* icons[ 12 ];
	KWaveControl *kwc;
	
	KPopupMenu *popup;
	QAction *openAction;
	QAction *closeAction;
	QAction *smallAction;
	
	/// the "normal" timer with idividual cycle
	QTimer *basicTimer;
	/// timer with 1s cycle for traffic analyse
	QTimer *secondTimer;
	/// timer for automatic scanning
	QTimer *autoScanTimer;
	
	/// main configuration widget
	WWidget *widget;
	/// widget with only link bar
	SmallWidget *smallWidget;
	/// pointer to the card interface
	WCard *card;
	
	/// the state of the link
	int state;
	int bitrate;
	int link, avg, signal, noise;
	int maxSignal, maxQual, maxNoise;
	
	/// tooltip text of the tray icon
	QString toolTipText;
	
	/// number of the state when we have no link
	static const int NO_LINK_STATE = 11;

public slots:
	void slotAct();
	void slotOpen();
	void slotClose();
	void slotPolling( double value );
	void slotSmall();
	void slotScan( ScanOptions scanOptions );
	void newCellsSlot( QMap< QString, KnownCell > newCells );

protected:
	void mousePressEvent ( QMouseEvent * );
	void setState( int value );
	KTrayWidget* kTrayWidget;
};

#endif
