/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ktraywidget.h"

#include "hi32-app-kwavecontrol.xpm"

KTrayWidget::KTrayWidget(QWidget *parent, const char *name) : QFrame( parent, name , Qt::WStyle_Customize | WStyle_NoBorder | Qt::WStyle_StaysOnTop | WX11BypassWM )//| WMacNoSheet | WStyle_Tool | WWinOwnDC )
{
	this->setFrameStyle( QFrame::Plain | QFrame::Box );
	this->setLineWidth( 1 );
	this->setPaletteBackgroundColor( Qt::yellow );

	showTimer = new QTimer( this );
	connect( showTimer, SIGNAL( timeout() ), this, SLOT( closeSlot() ) );
	secondTimer = new QTimer( this );
	connect( secondTimer, SIGNAL( timeout() ), this, SLOT( secondTimerSlot() ) );

	vBox = new QVBox( this );
	vBox->setMargin( 10 );
	vBox->setSpacing( 10 );

	QHBox* titleBox = new QHBox( vBox );
	titleBox->setSpacing( 10 );
	logo = new QLabel( titleBox );
	logo->setPixmap( hi32_app_kwavecontrol_xpm );
	logo->adjustSize();
	title = new QLabel( "<b>KWavecontrol</b>", titleBox );
	title->setAlignment( QLabel::AlignLeft );
	titleBox->adjustSize();
	
	childWidget = new QWidget( vBox );
	closeButton = new KPushButton( "Close", vBox );
	connect( closeButton, SIGNAL( clicked() ), this, SLOT( closeSlot() ) );
	
	childWidget->show();
	vBox->adjustSize();
	this->adjustSize();

	valueWidget = NULL;

	this->setFocusPolicy( QWidget::NoFocus );
	closeButton->setFocusPolicy( QWidget::NoFocus );
}


KTrayWidget::~KTrayWidget()
{
}


/*!
    \fn KTrayWidget::mousePressEvent( QMouseEvent * e )
 */
void KTrayWidget::mousePressEvent( QMouseEvent * e )
{
	QWidget::mousePressEvent( e );
	closeSlot();
}


/*!
    \fn KTrayWidget::adjustPosition()
 */
void KTrayWidget::adjustPosition()
{
	int width = qApp->desktop()->width();
	int height = qApp->desktop()->height();
	this->move( width - this->width() - 20, height - this->height() - 20 );
}


/*!
    \fn KTrayWidget::show()
 */
void KTrayWidget::show()
{
	showTimer->changeInterval( 5000 );
	secondTimer->start( 1000, false );
	secondCounter = 5;
	secondTimerSlot();
	QWidget::show();
}


/*!
    \fn KTrayWidget::closeSlot()
 */
void KTrayWidget::closeSlot()
{
	this->hide();
	secondTimer->stop();
}


/*!
    \fn KTrayWidget::setChildWidget( QWidget* widget )
 */
void KTrayWidget::setChildWidget( QWidget* widget )
{
	if( valueWidget != NULL )
	{
		delete valueWidget;
	}
	valueWidget = widget;
	valueWidget->adjustSize();
	valueWidget->reparent( childWidget, QPoint( 0, 0 ), true );
	childWidget->setMinimumSize( valueWidget->size() );
	vBox->adjustSize();
	this->adjustSize();
	this->adjustPosition();
}


/*!
    \fn KTrayWidget::secondTimerSlot()
 */
void KTrayWidget::secondTimerSlot()
{
	closeButton->setText( QString( "Close (" ) + QString::number( secondCounter ) + QString( ")" ) );
	closeButton->setIconSet( iconLoader.loadIcon( "fileclose", KIcon::Small ) );
	secondCounter--;
}


#include "ktraywidget.moc"
