/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KTRAYWIDGET_H
#define KTRAYWIDGET_H

#include <qwidget.h>
#include <qframe.h>
#include <qlabel.h>
#include <qapplication.h>
#include <qtimer.h>
#include <qvbox.h>
#include <kpushbutton.h>
#include <kiconloader.h>

/**
	@author Matthias Reif <matthias.reif@informatik.tu-chemnitz.de>
*/
class KTrayWidget : public QFrame
{
Q_OBJECT
public:
    KTrayWidget(QWidget *parent = 0, const char *name = 0);

    ~KTrayWidget();
    void adjustPosition();
    void show();
    void setChildWidget( QWidget* widget );

protected:
    void mousePressEvent( QMouseEvent* e );

private:
	QTimer* showTimer;
	QTimer* secondTimer;
	QVBox* vBox;
	QLabel* logo;
	QLabel* title;
	KPushButton* closeButton;
	QWidget* childWidget;
	QWidget* valueWidget;
	int secondCounter;
	KIconLoader iconLoader;
protected slots:
	void secondTimerSlot();
	void closeSlot();
};

#endif
