/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kwcentrydhcp.h"

KWCEntryDhcp::KWCEntryDhcp( KSingleTabWidget *parent, const char *name) : KWCEntry( "", parent, name )
{
	runButton = new KPushButton( "start dhcpcd", parent );
	startText = true;
	inscriptionLabel->hide();
	setValueWidget( runButton );

	runButton->setMinimumWidth( 140 );
	runButton->setMaximumWidth( 180 );
	runButton->setMaximumHeight( inscriptionLabel->height() + 4 );

	connect( runButton, SIGNAL( clicked() ), this, SLOT( buttonSlot() ) );
}


KWCEntryDhcp::~KWCEntryDhcp()
{
}


/*!
    \fn KWCEntryDhcp::buttonSlot()
 */
void KWCEntryDhcp::buttonSlot()
{
	buttonClicked();
}


/*!
    \fn KWCEntryDhcp::enableButton( bool on )
 */
void KWCEntryDhcp::enableButton( bool on )
{
	runButton->setEnabled( on );
}


/*!
    \fn KWCEntryDhcp::setButtonText( QString text )
 */
void KWCEntryDhcp::setButtonText( QString text )
{
	runButton->setText( text );
}


/*!
    \fn KWCEntryDhcp::setStartText( bool startText )
 */
void KWCEntryDhcp::setStartText( bool startText )
{
	if( startText != this->startText )
	{
		if( startText )
		{
			runButton->setText( "start dhcpcd" );
		}
		else
		{
			runButton->setText( "stop dhcpcd" );
		}
		this->startText = startText;
	}
}


#include "kwcentrydhcp.moc"
