/***************************************************************************
                          kwcentryspin.cpp  -  description
                             -------------------
    begin                : Mon Feb 3 2003
    copyright            : (C) 2003 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kwcentryspin.h"

/*!
	\fn KWCEntrySpin::KWCEntrySpin( const QString & inscr, double min, double max, double step, int precision, QString suffix,  KSingleTabWidget *parent, const char *name )
 */
KWCEntrySpin::KWCEntrySpin( const QString & inscr, double min, double max, double step, int precision, QString suffix,  KSingleTabWidget *parent, const char *name ) : KWCEntry( inscr, parent, name )
{
	pollingSpin = new KDoubleSpinBox( min, max, step, 0.0, precision, parent );
	pollingSpin->setSuffix( suffix );
	setValueWidget( pollingSpin );
	connect( pollingSpin, SIGNAL( valueChanged( double ) ), this, SLOT( valueChangedSlot( double ) ) );
}


/*!
	\fn KWCEntrySpin::~KWCEntrySpin()
 */
KWCEntrySpin::~KWCEntrySpin()
{
	delete pollingSpin;
}


/*!
	\fn KWCEntrySpin::valueChangedSlot( double value)
 */
void KWCEntrySpin::valueChangedSlot( double value)
{
	valueChanged( value );
}


/*!
	\fn KWCEntrySpin::setValue( double value )
 */
void KWCEntrySpin::setValue( double value )
{
	pollingSpin->setValue( value );
}
