/***************************************************************************
                          wwidget.h  -  description
                             -------------------
    begin                : Die Nov 12 2002
    copyright            : (C) 2002 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WWIDGET_H
#define WWIDGET_H

using namespace std;

#include <pwd.h>

#include <klocale.h>
#include <ktabctl.h>
#include <kiconloader.h>
#include <kdialogbase.h>
#include <qwhatsthis.h>
#include <qtimer.h>
#include <kmessagebox.h>

#include "wcard.h"
#include "config.h"

#include "ksingletabwidget.h"
#include "kwcentrylabel.h"
#include "kwcentryurllabel.h"
#include "kwcentryedit.h"
#include "kwcentrybar.h"
#include "kwcentryselection.h"
#include "kwcentryspin.h"
#include "kwcentrydhcp.h"

#include "ktraffictab.h"
#include "kscanwidget.h"
#include "kurllabel.h"
#include "qscanthread.h"
#include "qdhcpthread.h"
#include "kpowergroup.h"
#include "ktxpowergroup.h"
#include "kscanwidget.h"
#include "kprofilewidget.h"
#include "kinfowidget.h"
#include "kthresholdgroup.h"
#include "kexperiencedtab.h"
#include "kencryptiongroup.h"

#include "qwhatsthisstrings.h"

class QScanThread;

/**
  *@author Matthias Reif
  */
class WWidget : public KDialogBase {
   Q_OBJECT
public:
	WWidget(WCard *card, QString cmd, QWidget *parent=0, const char *name=0);
	~WWidget();
	void scanComplete( APInfos apInfos, int error, int errorNo );
	static QString bitrate2String( int bitrate );
	Profile getProfile();
	static QString frequency2QString( double frequency );
	void setProfile( Profile profile );
	KScanWidget* getScanWidget();

private:
	KTabCtl *tab;
	WCard *card;

	KSingleTabWidget* firstTab;
	KInfoWidget* infoTab;
	KExperiencedTab*  experiencedTab;
	KTrafficTab* trafficTab;
	KScanWidget* scanWidget;
	KProfileWidget* profileWidget;

	KWCEntrySelection* deviceSelection;
	KWCEntryDhcp* dhcpEntry;
	KWCEntryEdit* IPEdit;
	KWCEntryEdit* gatewayEdit;

	KWCEntryEdit* nickEdit;
	
	KWCEntrySelection *modeSelection;
	KWCEntryBar *linkBar;
	KWCEntryBar *signalBar;
	KWCEntryBar *noiseBar;
	KWCEntryLabel *encodingLabel;

	KWCEntrySpin *pollingSpin;
	
	KWCEntryLabel *protocolLabel;
	KWCEntrySelection *bitrateSelection;
	KWCEntrySelection *channelSelection;
	KWCEntryLabel *sensitivityLabel;
	KWCEntryEdit *essidEdit;

	KWCEntryLabel *macAPLabel;

	KWCEntrySelection *powerEnabledSelection;
	KWCEntrySelection *powerModeSelection;

	KPowerGroup* powerGroup;
	KTxPowerGroup* txPowerGroup;
	KThresholdGroup *rtsGroup;
	KThresholdGroup *fragGroup;
	KEncryptionGroup *encGroup;

	KWCEntryLabel *authorLabel;
	KWCEntryURLLabel *homepageLabel;
	KWCEntryLabel *versionLabel;
	KWCEntryLabel *licenseLabel;
	KWCEntryURLLabel *emailLabel;
	KWCEntryURLLabel *weVersionLabel;

	QScanThread* scanThread;
	QDhcpThread* dhcpThread;
	
	int link, signal, noise, avg;
	int maxQual, maxSignal, maxNoise;
	map< int, int > bitrateIndices;
	map< int, int > bitrateValues;
	char *buffer;
	double recv, sent;
	double freq;
	int numChannel, channel;
	bool isWave;
	QString channelString;
	bool scanning;
	bool dhcpThreadRunning;
	QString cmd;
	QString gateway;
	QTimer* dhcpTimer;

public slots:
	void basicTimerSlot();
	void secondTimerSlot();
	void setStaticInfo();
	void deviceSlot( const QString & text );
	void IPChangedSlot( const QString & text );
	void gatewaySlot( const QString & text );
	void nickSlot( const QString & text );
	void essidSlot( const QString & text );
	void bitrateSlot(int index);
	void modeSlot(int index);
	void sensitivitySlot(int index);
	void channelSlot( int index );
	void powerSlot( bool enabled, int mode );
	void txPowerSlot( bool disabled, bool fixed, int value, int unit );
	void setWave( bool is = true );
	void rootSlot();
	void scanSlot();
	void connectToAp( QString essid, double frequency, QString mode, bool enc, bool dhcp = false );
	void whatsThisSlot();
	void slotPolling( double value );
	void rtsSlot( bool enabled, int value );
	void fragSlot( bool enabled, int value );
	void tabSelectedSlot( int );
	void encryptionSlot( int mode, int index, unsigned char* key, int length );
	void encryptionSlot( int index, unsigned char* key, int length );
	void encryptionSlot( int index );
	void encryptionModeSlot( int mode );
	void dhcpSlot();

protected:
	void initTabs();
	void adjustEntries();
	void connectSignals();
	void setWhatsThis();
	void getWirelessDevices( QString preset );

signals:
	void pollingChanged( double value );

};

#endif
