/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.limegroup.bittorrent.BTChannelWriter;
import com.limegroup.bittorrent.BTInterval;
import com.limegroup.bittorrent.BTLink;
import com.limegroup.bittorrent.BTLinkListener;
import com.limegroup.bittorrent.BTMessageHandler;
import com.limegroup.bittorrent.BTMessageWriter;
import com.limegroup.bittorrent.BTPiece;
import com.limegroup.bittorrent.PieceReadListener;
import com.limegroup.bittorrent.PieceSendListener;
import com.limegroup.bittorrent.SimpleBandwidthTracker;
import com.limegroup.bittorrent.TorrentContext;
import com.limegroup.bittorrent.TorrentLocation;
import com.limegroup.bittorrent.disk.TorrentDiskManager;
import com.limegroup.bittorrent.messages.BTBitField;
import com.limegroup.bittorrent.messages.BTCancel;
import com.limegroup.bittorrent.messages.BTChoke;
import com.limegroup.bittorrent.messages.BTHave;
import com.limegroup.bittorrent.messages.BTInterested;
import com.limegroup.bittorrent.messages.BTMessage;
import com.limegroup.bittorrent.messages.BTNotInterested;
import com.limegroup.bittorrent.messages.BTPieceMessage;
import com.limegroup.bittorrent.messages.BTRequest;
import com.limegroup.bittorrent.messages.BTUnchoke;
import com.limegroup.bittorrent.messages.BadBTMessageException;
import com.limegroup.bittorrent.reader.BTMessageReader;
import com.limegroup.gnutella.BandwidthManager;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.uploader.UploadSlotListener;
import com.limegroup.gnutella.uploader.UploadSlotManager;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.BitField;
import org.limewire.collection.BitFieldSet;
import org.limewire.collection.BitSet;
import org.limewire.collection.NECallable;
import org.limewire.io.IOUtils;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.channel.ChannelReadObserver;
import org.limewire.nio.channel.ThrottleReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTConnection
implements UploadSlotListener,
BTMessageHandler,
BTLink,
PieceSendListener,
PieceReadListener {
    private static final Log LOG = LogFactory.getLog(BTConnection.class);
    private static final int MAX_BLOCK_SIZE = 65536;
    private static final int MAX_REQUESTS = 4;
    private static final long MIN_RETRYABLE_LIFE_TIME = 60000L;
    private static final int CONNECTION_TIMEOUT = 125000;
    private AbstractNBSocket _socket;
    private final ChannelReadObserver _reader;
    private final BTChannelWriter _writer;
    private volatile BitSet _availableRanges;
    private volatile BitField _available;
    private final Set<BTInterval> _requesting;
    private final Set<BTInterval> _requested;
    private final TorrentContext context;
    private final TorrentLocation _endpoint;
    private final BandwidthManager bwManager;
    private final UploadSlotManager usManager;
    private boolean _isChoked;
    private volatile boolean _isChoking;
    private boolean _isInterested;
    private volatile boolean _isInteresting;
    private long _startTime;
    private int numMissing;
    private int unchokeRound;
    private volatile boolean usingSlot;
    private SimpleBandwidthTracker up;
    private SimpleBandwidthTracker downShort;
    private SimpleBandwidthTracker downLong;
    private volatile boolean closing;
    private Runnable slotReleaser;
    private Runnable slotNotifier;
    private BTLinkListener listener;
    private ScheduledExecutorService invoker;

    public BTConnection(TorrentContext context, TorrentLocation ep, BandwidthManager bwManager, UploadSlotManager usManager) {
        this._endpoint = ep;
        this.context = context;
        this.bwManager = bwManager;
        this.usManager = usManager;
        this._availableRanges = new BitSet(context.getMetaInfo().getNumBlocks());
        this._available = new BitFieldSet(this._availableRanges, context.getMetaInfo().getNumBlocks());
        this._requesting = new HashSet<BTInterval>();
        this._requested = new HashSet<BTInterval>();
        this._isChoked = true;
        this._isChoking = true;
        this._isInterested = false;
        this._isInteresting = false;
        this.up = new SimpleBandwidthTracker();
        this.downShort = new SimpleBandwidthTracker(1000);
        this.downLong = new SimpleBandwidthTracker(5000);
        this._writer = new BTMessageWriter(this, this);
        this._reader = new BTMessageReader(this, this, NIODispatcher.instance().getScheduledExecutorService(), NIODispatcher.instance().getBufferCache());
    }

    public void init(AbstractNBSocket socket, BTLinkListener listener, ScheduledExecutorService invoker) {
        if (this.closing) {
            return;
        }
        this._socket = socket;
        try {
            this._socket.setSoTimeout(125000);
        }
        catch (SocketException se) {
            this.shutdown();
            return;
        }
        this.listener = listener;
        this.invoker = invoker;
        this._startTime = System.currentTimeMillis();
        this._writer.init(invoker, 120000, this.bwManager);
        ThrottleReader readThrottle = new ThrottleReader(this.bwManager.getReadThrottle());
        this._reader.setReadChannel(readThrottle);
        readThrottle.interestRead(true);
        this._socket.setReadObserver(this._reader);
        this._socket.setWriteObserver(this._writer);
        if (this.context.getDiskManager().getVerifiedBlockSize() > 0L) {
            this.numMissing = this.context.getDiskManager().getNumMissing(this._available);
            this.sendBitfield();
        }
    }

    @Override
    public boolean isChoked() {
        return this._isChoked;
    }

    @Override
    public boolean isChoking() {
        return this._isChoking;
    }

    @Override
    public boolean isInterested() {
        return this._isInterested;
    }

    @Override
    public boolean shouldBeInterested() {
        return this.numMissing > 0;
    }

    @Override
    public boolean isInteresting() {
        return this._isInteresting;
    }

    @Override
    public boolean isWorthRetrying() {
        return System.currentTimeMillis() - this._startTime > 60000L;
    }

    @Override
    public TorrentLocation getEndpoint() {
        return this._endpoint;
    }

    private void close() {
        if (this.closing) {
            return;
        }
        this.closing = true;
        if (this._socket == null) {
            return;
        }
        IOUtils.close(this._socket);
        this.clearRequests();
        this.cancelSlotRequest();
        this.listener.linkClosed(this);
    }

    private void cancelSlotRequest() {
        if (this.usingSlot) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + " cancelling slot request");
            }
            this.usManager.cancelRequest(this);
        }
        this.usingSlot = false;
    }

    @Override
    public float getMeasuredBandwidth(boolean read, boolean shortTerm) {
        SimpleBandwidthTracker tracker = !read ? this.up : (shortTerm ? this.downShort : this.downLong);
        tracker.measureBandwidth();
        try {
            return tracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException ide) {
            return 0.0f;
        }
    }

    @Override
    public void readBytes(int read) {
        this.downShort.count(read);
        this.downLong.count(read);
        this.listener.countDownloaded(read);
    }

    @Override
    public void wroteBytes(int written) {
        this.up.count(written);
        this.context.getMetaInfo().countUploaded(written);
    }

    @Override
    public void handleIOException(IOException iox) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(iox);
        }
        this.shutdown();
    }

    @Override
    public void shutdown() {
        this.close();
    }

    @Override
    public void choke() {
        this._requested.clear();
        if (!this._isChoked) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + " choking");
            }
            this.cancelSlotRequest();
            this._writer.enqueue(BTChoke.createMessage());
            this._isChoked = true;
        }
    }

    @Override
    public void unchoke(int now) {
        this.unchokeRound = now;
        if (this._isChoked) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + " unchoking, round " + now);
            }
            this._writer.enqueue(BTUnchoke.createMessage());
            this._isChoked = false;
        }
    }

    @Override
    public int getUnchokeRound() {
        return this.unchokeRound;
    }

    @Override
    public void clearUnchokeRound() {
        this.unchokeRound = -1;
    }

    private void sendInterested() {
        if (!this._isInteresting) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + " we become interested");
            }
            this._writer.enqueue(BTInterested.createMessage());
            this._isInteresting = true;
        }
    }

    void sendNotInterested() {
        this.cancelAllRequests();
        if (this._isInteresting) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + " we lose interest");
            }
            this._writer.enqueue(BTNotInterested.createMessage());
            this._isInteresting = false;
        }
    }

    @Override
    public void sendHave(BTHave have) {
        int pieceNum = have.getPieceNum();
        if (!this._available.get(pieceNum)) {
            ++this.numMissing;
            this._writer.enqueue(have);
        }
        if (!this.context.getDiskManager().containsAnyWeMiss(this._available)) {
            this.sendNotInterested();
            return;
        }
        Iterator<BTInterval> iter = this._requesting.iterator();
        while (iter.hasNext()) {
            BTInterval req = iter.next();
            if (req.getId() != pieceNum) continue;
            iter.remove();
            this.sendCancel(req);
        }
        if (!this._isChoking) {
            this.request();
        }
    }

    private void sendBitfield() {
        this._writer.enqueue(BTBitField.createMessage(this.context));
    }

    private void sendCancel(BTInterval in) {
        this._writer.enqueue(new BTCancel(in));
    }

    private void cancelAllRequests() {
        for (BTInterval request : this._requesting) {
            this.sendCancel(request);
        }
        this.clearRequests();
    }

    @Override
    public void pieceSent() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this + " piece sent");
        }
        this.usingSlot = false;
        this.usManager.requestDone(this);
        this.readyForWriting();
    }

    private void readyForWriting() {
        if (this._isChoked || this._requested.isEmpty()) {
            return;
        }
        this.usingSlot = true;
        int proceed = this.usManager.requestSlot(this, !this.context.getDiskManager().isComplete());
        if (proceed == -1) {
            this.usingSlot = false;
            this.choke();
        } else if (proceed == 0) {
            this.beginPieceSend();
        }
    }

    private void beginPieceSend() {
        if (this._isChoked || this._requested.isEmpty()) {
            return;
        }
        Iterator<BTInterval> iter = this._requested.iterator();
        BTInterval in = iter.next();
        iter.remove();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this + " requesting disk read for " + in);
        }
        this.context.getDiskManager().requestPieceRead(in, this);
    }

    @Override
    public void pieceRead(final BTInterval in, final byte[] data) {
        this.bwManager.applyUploadRate();
        Runnable pieceSender = new Runnable(){

            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("disk read done for " + in);
                }
                BTConnection.this._writer.enqueue(new BTPieceMessage(in, data));
            }
        };
        this.invoker.execute(pieceSender);
    }

    @Override
    public void pieceReadFailed(BTInterval interval) {
        this.cancelSlotRequest();
    }

    private void clearRequests() {
        for (BTInterval clear : this._requesting) {
            this.context.getDiskManager().releaseInterval(clear);
        }
        this._requesting.clear();
    }

    @Override
    public void processMessage(BTMessage message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this + " handling message " + message);
        }
        switch (message.getType()) {
            case 0: {
                this._isChoking = true;
                this.clearRequests();
                break;
            }
            case 1: {
                this._isChoking = false;
                if (!this._isInteresting) break;
                this.request();
                break;
            }
            case 2: {
                this._isInterested = true;
                this.listener.linkInterested(this);
                break;
            }
            case 3: {
                this._isInterested = false;
                this._requested.clear();
                this.listener.linkNotInterested(this);
                if (!this.context.getDiskManager().isComplete()) break;
                this.close();
                break;
            }
            case 5: {
                this.handleBitField((BTBitField)message);
                break;
            }
            case 4: {
                this.handleHave((BTHave)message);
                break;
            }
            case 6: {
                this.handleRequest((BTRequest)message);
                break;
            }
            case 8: {
                this.handleCancel((BTCancel)message);
            }
        }
    }

    private void handleCancel(BTCancel message) {
        BTInterval in = message.getInterval();
        this._requested.remove(in);
        Iterator<BTInterval> iter = this._requested.iterator();
        while (iter.hasNext()) {
            BTInterval current = iter.next();
            if (in.getId() != current.getId() || in.getLow() > current.getHigh() || current.getLow() > in.getHigh()) continue;
            iter.remove();
        }
    }

    private void handleRequest(BTRequest message) {
        if (this._isChoked) {
            return;
        }
        BTInterval in = message.getInterval();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this + " got request for " + in);
        }
        if (in.getId() > this.context.getMetaInfo().getNumBlocks()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("got bad request " + message);
            }
            return;
        }
        if (in.getHigh() - in.getLow() + 1L > 65536L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("got long request");
            }
            return;
        }
        if (this.context.getDiskManager().hasBlock(in.getId())) {
            this._requested.add(in);
        }
        if (!this._requested.isEmpty() && !this.usingSlot) {
            this.readyForWriting();
        }
    }

    @Override
    public boolean startReceivingPiece(BTInterval interval) {
        if (!this._requesting.remove(interval)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("received unexpected range " + interval + " from " + this._socket.getInetAddress() + " expected " + this._requesting);
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this + " starting to receive piece " + interval);
        }
        return true;
    }

    @Override
    public void finishReceivingPiece() {
        this.request();
    }

    void request() {
        BTInterval in;
        if (LOG.isDebugEnabled()) {
            LOG.debug("requesting ranges from " + this);
        }
        if (this._requesting.size() > 1) {
            return;
        }
        while (this._requesting.size() < 4 && (in = this.context.getDiskManager().leaseRandom(this._available, this._requesting)) != null) {
            this._requesting.add(in);
            this._writer.enqueue(new BTRequest(in));
        }
    }

    @Override
    public void handlePiece(NECallable<BTPiece> factory) {
        this.context.getDiskManager().writeBlock(factory);
    }

    private void handleBitField(BTBitField message) {
        ByteBuffer field = message.getPayload();
        int numBits = this.context.getMetaInfo().getNumBlocks();
        int bitFieldLength = (numBits + 7) / 8;
        if (field.remaining() != bitFieldLength) {
            this.handleIOException(new BadBTMessageException("bad bitfield received! " + this._endpoint.toString()));
        }
        boolean willBeInteresting = false;
        for (int i = 0; i < numBits; ++i) {
            byte mask = (byte)(128 >>> i % 8);
            if ((mask & field.get(i / 8)) != mask) continue;
            if (!willBeInteresting && !this.context.getDiskManager().hasBlock(i)) {
                willBeInteresting = true;
            }
            this._availableRanges.set(i);
        }
        if (this._available.cardinality() == numBits) {
            this._availableRanges = null;
            this._available = this.context.getFullBitField();
            this.numMissing = 0;
        } else {
            this.numMissing = this.context.getDiskManager().getNumMissing(this._available);
        }
        if (willBeInteresting) {
            this.sendInterested();
        }
    }

    private void handleHave(BTHave message) {
        int pieceNum = message.getPieceNum();
        if (pieceNum >= this._available.maxSize()) {
            this.shutdown();
            return;
        }
        if (this._available.get(pieceNum)) {
            return;
        }
        TorrentDiskManager v = this.context.getDiskManager();
        this._availableRanges.set(pieceNum);
        if (v.hasBlock(pieceNum)) {
            --this.numMissing;
        } else {
            this.sendInterested();
        }
        if (this._available.cardinality() == this.context.getMetaInfo().getNumBlocks()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + " now has everything");
            }
            this._availableRanges = null;
            this._available = this.context.getFullBitField();
            this.numMissing = 0;
            if (v.isComplete()) {
                this.shutdown();
            }
        }
    }

    public boolean equals(Object o) {
        if (o instanceof BTConnection) {
            BTConnection other = (BTConnection)o;
            return other._endpoint.equals(this._endpoint);
        }
        return false;
    }

    public String toString() {
        int requesting;
        int requested;
        StringBuilder b = new StringBuilder(this._socket == null ? "new" : "(" + this.getHost());
        if (this.isChoked()) {
            b.append(" Ced");
        }
        if (this.isChoking()) {
            b.append(" Cing");
        }
        if (this.isInterested()) {
            b.append(" Ied");
        }
        if (this.isInteresting()) {
            b.append(" Iing");
        }
        if (this.isSeed()) {
            b.append(" Seed");
        }
        if (this.usingSlot) {
            b.append(" U");
        }
        if ((requested = this._requested.size()) > 0) {
            b.append(" Q").append(requested);
        }
        if ((requesting = this._requesting.size()) > 0) {
            b.append(" D").append(requesting);
        }
        b.append(")");
        return b.toString();
    }

    @Override
    public String getHost() {
        return this._socket.getInetAddress().getHostAddress();
    }

    @Override
    public void releaseSlot() {
        this.invoker.execute(this.getSlotReleaser());
    }

    private Runnable getSlotReleaser() {
        if (this.slotReleaser == null) {
            this.slotReleaser = new Runnable(){

                public void run() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(BTConnection.this + " releasing slot");
                    }
                    BTConnection.this.choke();
                }
            };
        }
        return this.slotReleaser;
    }

    @Override
    public void slotAvailable() {
        this.invoker.execute(this.getSlotNotifier());
    }

    private Runnable getSlotNotifier() {
        if (this.slotNotifier == null) {
            this.slotNotifier = new Runnable(){

                public void run() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(BTConnection.this + " got available slot");
                    }
                    BTConnection.this.beginPieceSend();
                }
            };
        }
        return this.slotNotifier;
    }

    @Override
    public float getAverageBandwidth() {
        return this.up.getAverageBandwidth();
    }

    @Override
    public float getMeasuredBandwidth() throws InsufficientDataException {
        return this.up.getMeasuredBandwidth();
    }

    @Override
    public void measureBandwidth() {
        this.up.measureBandwidth();
    }

    @Override
    public boolean isSeed() {
        return this._available.cardinality() == this.context.getMetaInfo().getNumBlocks();
    }

    public boolean isBusy() {
        return !this.isInteresting();
    }

    @Override
    public boolean isUploading() {
        return this.isInterested() && !this.isChoked();
    }

    @Override
    public void suspendTraffic() {
        this.sendNotInterested();
        this.choke();
    }
}

