/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.limegroup.bittorrent.BTData;
import com.limegroup.bittorrent.ValueException;
import com.limegroup.gnutella.security.SHA1;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.limewire.service.ErrorService;
import org.limewire.util.BEncoder;
import org.limewire.util.CommonUtils;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTDataImpl
implements BTData {
    private final String announce;
    private byte[] pieces;
    private final Long pieceLength;
    private byte[] infoHash;
    private final String name;
    private final Long length;
    private final List<BTData.BTFileData> files;
    private final Set<String> folders;
    private final boolean isPrivate;

    public BTDataImpl(Map<?, ?> torrentFileMap) throws ValueException {
        Object tmp = torrentFileMap.get("announce");
        if (!(tmp instanceof byte[])) {
            throw new ValueException("announce missing or invalid!");
        }
        this.announce = StringUtils.getASCIIString((byte[])tmp);
        tmp = torrentFileMap.get("info");
        if (tmp == null || !(tmp instanceof Map)) {
            throw new ValueException("info missing or invalid!");
        }
        Map infoMap = (Map)tmp;
        this.infoHash = this.calculateInfoHash(infoMap);
        tmp = infoMap.get("private");
        this.isPrivate = tmp instanceof Long ? ((Long)tmp).intValue() == 1 : false;
        tmp = infoMap.get("pieces");
        if (!(tmp instanceof byte[])) {
            throw new ValueException("info->piece missing!");
        }
        this.pieces = (byte[])tmp;
        tmp = infoMap.get("piece length");
        if (!(tmp instanceof Long)) {
            throw new ValueException("info->'piece length' missing!");
        }
        this.pieceLength = (Long)tmp;
        tmp = infoMap.get("name.utf-8");
        this.name = this.getPreferredString(infoMap, "name");
        if (this.name == null || this.name.length() == 0) {
            throw new ValueException("no valid name!");
        }
        if (infoMap.containsKey("length") == infoMap.containsKey("files")) {
            throw new ValueException("info->length & info.files can't both exist or not exist!");
        }
        tmp = infoMap.get("length");
        if (tmp instanceof Long) {
            this.length = (Long)tmp;
            if (this.length < 0L) {
                throw new ValueException("invalid length value");
            }
        } else {
            if (tmp != null) {
                throw new ValueException("info->length is non-null, but not a Long!");
            }
            this.length = null;
        }
        if ((tmp = infoMap.get("files")) instanceof List) {
            List fileData = (List)tmp;
            if (fileData.isEmpty()) {
                throw new ValueException("empty file list");
            }
            this.files = new ArrayList<BTData.BTFileData>(fileData.size());
            this.folders = new HashSet<String>();
            for (Object o : fileData) {
                if (!(o instanceof Map)) {
                    throw new ValueException("info->files[x] not a Map!");
                }
                Map fileMap = (Map)o;
                tmp = fileMap.get("length");
                if (!(tmp instanceof Long)) {
                    throw new ValueException("info->files[x].length not a Long!");
                }
                Long ln = (Long)tmp;
                if (ln < 0L) {
                    throw new ValueException("invalid length");
                }
                boolean doASCII = true;
                try {
                    this.parseFiles(fileMap, ln, this.files, this.folders, true);
                    doASCII = false;
                }
                catch (ValueException ignored) {
                    // empty catch block
                }
                if (!doASCII) continue;
                this.parseFiles(fileMap, ln, this.files, this.folders, false);
            }
        } else {
            if (tmp != null) {
                throw new ValueException("info->files is non-null, but not a list!");
            }
            this.files = null;
            this.folders = null;
        }
    }

    private void parseFiles(Map<?, ?> fileMap, Long ln, List<BTData.BTFileData> fileData, Set<String> folderData, boolean utf8) throws ValueException {
        Object tmp = fileMap.get("path" + (utf8 ? ".utf-8" : ""));
        if (!(tmp instanceof List)) {
            throw new ValueException("info->files[x].path[.utf-8] not a List!");
        }
        HashSet<String> newFolders = new HashSet<String>();
        String path = this.parseFileList((List)tmp, newFolders, true);
        if (path == null) {
            throw new ValueException("info->files[x].path[-utf-8] not valid!");
        }
        folderData.addAll(newFolders);
        fileData.add(new BTData.BTFileData(ln, path));
    }

    private String parseFileList(List<?> paths, Set<String> folders, boolean utf8) throws ValueException {
        if (paths.isEmpty()) {
            throw new ValueException("empty paths list");
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> i = paths.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof byte[])) {
                throw new ValueException("info->files[x]->path[.utf-8][x] not a byte[]!");
            }
            String current = utf8 ? StringUtils.getUTF8String((byte[])o) : StringUtils.getASCIIString((byte[])o);
            if (current.length() == 0) {
                throw new ValueException("empty path element");
            }
            sb.append(File.separator);
            sb.append(CommonUtils.convertFileName(current));
            if (!i.hasNext()) continue;
            folders.add(sb.toString());
        }
        return sb.toString();
    }

    private String getPreferredString(Map<?, ?> info, String key) {
        String str = null;
        Object data = info.get(key + ".utf-8");
        if (data instanceof byte[]) {
            try {
                str = new String((byte[])data, "UTF-8");
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (str == null && (data = info.get(key)) instanceof byte[]) {
            str = StringUtils.getASCIIString((byte[])data);
        }
        return str;
    }

    private byte[] calculateInfoHash(Map<?, ?> infoMap) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            BEncoder.getEncoder(baos, true, false, "UTF-8").encodeDict(infoMap);
        }
        catch (IOException ioe) {
            ErrorService.error(ioe);
        }
        SHA1 md = new SHA1();
        return md.digest(baos.toByteArray());
    }

    @Override
    public String getAnnounce() {
        return this.announce;
    }

    @Override
    public List<BTData.BTFileData> getFiles() {
        return this.files;
    }

    @Override
    public Set<String> getFolders() {
        return this.folders;
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public byte[] getInfoHash() {
        return this.infoHash;
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Long getPieceLength() {
        return this.pieceLength;
    }

    @Override
    public byte[] getPieces() {
        return this.pieces;
    }

    @Override
    public void clearPieces() {
        this.pieces = null;
    }
}

