/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import org.limewire.collection.LongInterval;
import org.limewire.collection.Range;

public class BTInterval
extends LongInterval {
    private static final long serialVersionUID = 6565199693843714608L;
    private final int blockId;
    private int hashCode;

    public BTInterval(long low, long high, int id) {
        super(low, high);
        if (id < 0) {
            throw new IllegalArgumentException("negative id");
        }
        this.blockId = id;
    }

    public BTInterval(Range other, int id) {
        this(other.getLow(), other.getHigh(), id);
    }

    public BTInterval(long singleton, int id) {
        super(singleton);
        this.blockId = id;
    }

    public int getId() {
        return this.blockId;
    }

    public boolean equals(Object other) {
        if (!(other instanceof BTInterval)) {
            return false;
        }
        BTInterval o = (BTInterval)other;
        if (this.getId() != o.getId()) {
            return false;
        }
        return super.equals(other);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 17 * this.getId();
            this.hashCode = (int)((long)this.hashCode * (37L + this.getLow()));
            this.hashCode = (int)((long)this.hashCode * (37L + this.getHigh()));
        }
        return this.hashCode;
    }

    public int getBlockId() {
        return this.blockId;
    }

    public String toString() {
        return this.getId() + ":" + super.toString();
    }

    public int get32BitLow() {
        return BTInterval.get32Bit(this.getLow());
    }

    public int get32BitHigh() {
        return BTInterval.get32Bit(this.getHigh());
    }

    public int get32BitLength() {
        long length = this.getHigh() - this.getLow() + 1L;
        return BTInterval.get32Bit(length);
    }

    private static int get32Bit(long l) {
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE + (int)(l - Integer.MAX_VALUE);
        }
        return (int)l;
    }
}

