/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.limegroup.bittorrent.BTLink;
import com.limegroup.bittorrent.Chokable;
import com.limegroup.bittorrent.TorrentLocation;
import com.limegroup.bittorrent.messages.BTHave;
import com.limegroup.gnutella.util.StrictIpPortSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.limewire.collection.NECallable;
import org.limewire.nio.observer.Shutdownable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTLinkManager
implements Shutdownable,
NECallable<List<? extends Chokable>> {
    private final List<BTLink> _connections = new ArrayList<BTLink>();
    private final Set<TorrentLocation> endpoints = new StrictIpPortSet<TorrentLocation>();

    BTLinkManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        ArrayList<BTLink> copy;
        BTLinkManager bTLinkManager = this;
        synchronized (bTLinkManager) {
            this.endpoints.clear();
            copy = new ArrayList<BTLink>(this._connections);
            this._connections.clear();
        }
        for (BTLink toClose : copy) {
            toClose.shutdown();
        }
    }

    @Override
    public synchronized List<? extends Chokable> call() {
        return new ArrayList<BTLink>(this._connections);
    }

    public synchronized void sendHave(BTHave have) {
        for (BTLink btc : this._connections) {
            btc.sendHave(have);
        }
    }

    public synchronized int getNumConnections() {
        return this._connections.size();
    }

    public synchronized void addLink(BTLink link) {
        this._connections.add(link);
        this.endpoints.add(link.getEndpoint());
    }

    public synchronized void removeLink(BTLink link) {
        this._connections.remove(link);
        this.endpoints.remove(link.getEndpoint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectSeedsChokeRest() {
        ArrayList<BTLink> seeds = new ArrayList<BTLink>(this._connections.size());
        ArrayList<BTLink> notSeeds = new ArrayList<BTLink>(this._connections.size());
        BTLinkManager bTLinkManager = this;
        synchronized (bTLinkManager) {
            for (BTLink btc : this._connections) {
                if (btc.isSeed()) {
                    seeds.add(btc);
                    continue;
                }
                notSeeds.add(btc);
            }
        }
        for (BTLink seed : seeds) {
            seed.shutdown();
        }
        for (BTLink notSeed : notSeeds) {
            notSeed.suspendTraffic();
        }
    }

    public synchronized boolean isConnectedTo(TorrentLocation to) {
        return this.endpoints.contains(to);
    }

    public synchronized int getNumNonInterestingPeers() {
        int busy = 0;
        for (BTLink con : this._connections) {
            if (con.isInteresting()) continue;
            ++busy;
        }
        return busy;
    }

    public synchronized int getNumChockingPeers() {
        int qd = 0;
        for (BTLink c : this._connections) {
            if (!c.isChoking()) continue;
            ++qd;
        }
        return qd;
    }

    public List<BTLink> getConnections() {
        return this._connections;
    }

    public synchronized void measureBandwidth() {
        for (BTLink con : this._connections) {
            con.measureBandwidth();
        }
    }

    public synchronized float getMeasuredBandwidth(boolean downstream) {
        float ret = 0.0f;
        for (BTLink con : this._connections) {
            ret += con.getMeasuredBandwidth(downstream, true);
        }
        return ret;
    }

    public synchronized boolean hasUploading() {
        for (BTLink link : this._connections) {
            if (!link.isUploading()) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean hasUnchoked() {
        if (this._connections.isEmpty()) {
            return false;
        }
        for (BTLink link : this._connections) {
            if (link.isChoked()) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean hasInterested() {
        if (this._connections.isEmpty()) {
            return false;
        }
        for (BTLink link : this._connections) {
            if (link.isInterested()) continue;
            return true;
        }
        return false;
    }
}

